/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.MediaReceiver;
import com.teamdev.jxbrowser.cast.internal.rpc.CastModeSet;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverDetailsRequest;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverDisconnected;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverInfo;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverStateResult;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverStub;
import com.teamdev.jxbrowser.cast.rpc.CastMode;
import com.teamdev.jxbrowser.cast.rpc.MediaReceiverState;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.MediaReceiverId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.List;

public final class MediaReceiverImpl
extends CloseableImpl
implements MediaReceiver {
    private final MediaReceiverInfo receiverInfo;
    private final ServiceConnectionImpl<MediaReceiverStub> rpc;
    private final ProfileImpl profile;

    public MediaReceiverImpl(MediaReceiverInfo receiverInfo, ProfileImpl profile) {
        this.receiverInfo = receiverInfo;
        this.rpc = new ServiceConnectionImpl<MediaReceiverStub>(receiverInfo.getId(), profile.engine().connection(), MediaReceiverStub::new);
        this.profile = profile;
        this.rpc.setEventInterceptor(MediaReceiverDisconnected.class, event -> {
            this.rpc.dispatch(event);
            profile.mediaCasting().mediaReceivers().removeReceiver(event.getReceiverId());
            return Interceptor.Action.CANCEL;
        });
    }

    public MediaReceiverId id() {
        return this.receiverInfo.getId();
    }

    @Override
    public String name() {
        return this.receiverInfo.getFriendlyName();
    }

    @Override
    public MediaReceiverState state() {
        this.checkNotClosed();
        return ((MediaReceiverStateResult)this.rpc.invoke(this.rpc.stub()::getState, this.receiverDetailsRequest())).getState();
    }

    @Override
    public List<CastMode> modes() {
        return ((CastModeSet)this.rpc.invoke(this.rpc.stub()::getCastModes, this.receiverDetailsRequest())).getModeList().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean supports(CastMode mode) {
        return this.modes().contains(mode);
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    private MediaReceiverDetailsRequest receiverDetailsRequest() {
        return MediaReceiverDetailsRequest.newBuilder().setReceiverId(this.receiverInfo.getId()).setProfileId(this.profile.id()).build();
    }

    @Override
    public <E extends com.teamdev.jxbrowser.cast.event.MediaReceiverDisconnected> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

