/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.MediaReceiver;
import com.teamdev.jxbrowser.cast.MediaReceivers;
import com.teamdev.jxbrowser.cast.ReceiverNotDiscoveredException;
import com.teamdev.jxbrowser.cast.event.MediaReceiversEvent;
import com.teamdev.jxbrowser.cast.internal.MediaReceiverImpl;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverDiscovered;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverInfo;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverList;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiversStub;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.rpc.MediaReceiverId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class MediaReceiversImpl
extends CloseableImpl
implements MediaReceivers {
    private static final Duration DEFAULT_TIME_TO_DISCOVER = Duration.ofSeconds(45L);
    private final IdMap<MediaReceiverId, MediaReceiverImpl> availableReceivers;
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<MediaReceiversStub> rpc;
    private final Map<Predicate<MediaReceiver>, DiscoverableReceiver> discoverableReceivers;

    MediaReceiversImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.availableReceivers = new IdMap();
        this.discoverableReceivers = new ConcurrentHashMap<Predicate<MediaReceiver>, DiscoverableReceiver>();
        this.rpc = new ServiceConnectionImpl<MediaReceiversStub>(profile.id(), profile.engine().connection(), MediaReceiversStub::new);
    }

    void startDiscovering() {
        this.initialReceivers().forEach(mediaReceiver -> this.availableReceivers.put(mediaReceiver.id(), (MediaReceiverImpl)mediaReceiver));
        this.rpc.setEventInterceptor(MediaReceiverDiscovered.class, event -> {
            MediaReceiverId id = event.getReceiver().getId();
            MediaReceiverImpl receiver = new MediaReceiverImpl(event.getReceiver(), this.profile);
            this.availableReceivers.putIfAbsent(id, receiver);
            this.discoverableReceivers.keySet().stream().filter(predicate -> predicate.test(receiver)).findFirst().ifPresent(predicate -> {
                DiscoverableReceiver discoverableReceiver = this.discoverableReceivers.get(predicate);
                discoverableReceiver.onDiscovered(receiver);
            });
            return Interceptor.Action.PROCEED;
        });
    }

    public Optional<MediaReceiverImpl> byId(MediaReceiverId receiverId) {
        return this.availableReceivers.find(receiverId);
    }

    private List<MediaReceiverImpl> initialReceivers() {
        this.checkNotClosed();
        return ((MediaReceiverList)this.rpc.invoke(this.rpc.stub()::getReceivers, this.profile.id())).getReceiverList().stream().map(receiverInfo -> new MediaReceiverImpl((MediaReceiverInfo)receiverInfo, this.profile)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    @Override
    public List<MediaReceiver> list() {
        this.checkNotClosed();
        return this.availableReceivers.values().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public MediaReceiver await(Predicate<MediaReceiver> predicate) {
        return this.await(predicate, DEFAULT_TIME_TO_DISCOVER);
    }

    @Override
    public MediaReceiver await(Predicate<MediaReceiver> predicate, Duration timeout) {
        this.checkNotClosed();
        Preconditions.checkNotNull(predicate);
        Preconditions.checkNotNull(timeout);
        Optional<MediaReceiver> receiver = this.availableReceivers.values().stream().filter(predicate).findAny();
        if (receiver.isPresent()) {
            return receiver.get();
        }
        DiscoverableReceiver discoverableReceiver = new DiscoverableReceiver();
        this.discoverableReceivers.put(predicate, discoverableReceiver);
        try {
            boolean receiverDiscovered = discoverableReceiver.await(timeout);
            if (receiverDiscovered) {
                Preconditions.checkState(discoverableReceiver.receiver != null, "The receiver should not be null.");
                MediaReceiver mediaReceiver = discoverableReceiver.receiver;
                return mediaReceiver;
            }
            try {
                throw new ReceiverNotDiscoveredException();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.discoverableReceivers.remove(predicate);
        }
    }

    void removeReceiver(MediaReceiverId receiverId) {
        this.availableReceivers.remove(receiverId);
    }

    @Override
    public void close() {
        this.availableReceivers.values().forEach(CloseableImpl::close);
        super.close();
    }

    @Override
    public <E extends MediaReceiversEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    private static final class DiscoverableReceiver {
        private final CountDownLatch latch = new CountDownLatch(1);
        private MediaReceiver receiver;

        private DiscoverableReceiver() {
        }

        private boolean await(Duration time) throws InterruptedException {
            return this.latch.await(time.toNanos(), TimeUnit.NANOSECONDS);
        }

        private void onDiscovered(MediaReceiver receiver) {
            this.receiver = receiver;
            this.latch.countDown();
        }
    }
}

