/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.cache.HttpAuthCache;
import com.teamdev.jxbrowser.cache.HttpCache;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.engine.ChromiumBinariesExtractionException;
import com.teamdev.jxbrowser.engine.ChromiumProcessStartupFailureException;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineInitializationException;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.IpcSetupFailureException;
import com.teamdev.jxbrowser.engine.UserDataDirectoryAlreadyInUseException;
import com.teamdev.jxbrowser.engine.UserDataDirectoryCreationException;
import com.teamdev.jxbrowser.engine.event.EngineClosed;
import com.teamdev.jxbrowser.engine.event.EngineCrashed;
import com.teamdev.jxbrowser.engine.event.EngineEvent;
import com.teamdev.jxbrowser.engine.event.internal.EngineClosedImpl;
import com.teamdev.jxbrowser.engine.event.internal.EngineCrashedImpl;
import com.teamdev.jxbrowser.engine.internal.ClassPreLoader;
import com.teamdev.jxbrowser.engine.internal.FileLock;
import com.teamdev.jxbrowser.engine.internal.LicenseExceptionFactory;
import com.teamdev.jxbrowser.engine.internal.LinuxDependencies;
import com.teamdev.jxbrowser.engine.internal.StackTrace;
import com.teamdev.jxbrowser.engine.internal.TempUserDataDirs;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.ChromiumExtractor;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.ChromiumVerifier;
import com.teamdev.jxbrowser.internal.ChromiumVerifiers;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.ExitCode;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.JniLibrary;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessStartFailed;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessTerminated;
import com.teamdev.jxbrowser.internal.licensing.License;
import com.teamdev.jxbrowser.internal.licensing.LicenseVerificationStatus;
import com.teamdev.jxbrowser.internal.memory.SharedMemoryManager;
import com.teamdev.jxbrowser.internal.platform.mac.MachService;
import com.teamdev.jxbrowser.internal.rpc.ApplyLicenseResponse;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.EngineFactoryStub;
import com.teamdev.jxbrowser.internal.rpc.EngineId;
import com.teamdev.jxbrowser.internal.rpc.EngineStub;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionServer;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.media.MediaDevices;
import com.teamdev.jxbrowser.media.internal.MediaDevicesImpl;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.proxy.Proxy;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.permission.Permissions;
import com.teamdev.jxbrowser.plugin.Plugins;
import com.teamdev.jxbrowser.profile.internal.ProfilesImpl;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.zoom.ZoomLevels;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class EngineImpl
extends CloseableImpl
implements Engine {
    public static final TempUserDataDirs tempUserDataDirs = new TempUserDataDirs();
    private static final int IPC_SETUP_TIMEOUT_IN_SECONDS = 600;
    private static final String EXTRACTION_LOCK_FILE_NAME = "extraction.lock";
    private static final IdMap<EngineId, EngineImpl> engineIdToEngineMap = new IdMap();
    private final EngineId id;
    private final EngineOptions options;
    private final ChromiumProcess chromiumProcess;
    private final RenderProcesses renderProcesses;
    private final Connection connection;
    private final ConnectionServer connectionServer;
    private final ServiceConnectionImpl<EngineStub> rpc;
    private final Subscription chromiumProcessTerminated;
    private final ObservableHelper<EngineEvent> observable;
    private final ProfilesImpl profiles;
    private final Lazy<MachService> machService;
    private final Lazy<MediaDevicesImpl> mediaDevices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineImpl newInstance(EngineOptions options) {
        ChromiumProcessTerminated chromiumProcessTerminated;
        Preconditions.checkNotNull(options);
        Environment.checkEnvironment();
        Path chromiumDir = options.chromiumDir();
        JniLibrary.path(chromiumDir);
        EngineImpl.extractChromiumBinariesIfNecessary(chromiumDir);
        if (Environment.isLinux()) {
            new LinuxDependencies(chromiumDir).checkAvailability();
        }
        EngineImpl.configureProcessDpiAwareness();
        Path userDataDir = options.userDataDir();
        String licenseKey = options.licenseKey().orElse("");
        ConnectionServer connectionServer = new ConnectionServer();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference connectionIdRef = new AtomicReference();
        Subscription connectionCreated = connectionServer.on(ConnectionCreated.class, event -> {
            if (event.connection().type().equals(ConnectionType.BROWSER)) {
                connectionIdRef.set(event.connection().id());
                latch.countDown();
            }
        });
        ChromiumProcess chromiumProcess = ChromiumProcess.create(connectionServer.port(), chromiumDir);
        AtomicReference chromiumProcessStartFailedRef = new AtomicReference();
        AtomicReference chromiumProcessTerminatedRef = new AtomicReference();
        chromiumProcess.on(ChromiumProcessStartFailed.class, event -> {
            chromiumProcessStartFailedRef.set(event);
            latch.countDown();
        });
        chromiumProcess.on(ChromiumProcessTerminated.class, event -> {
            chromiumProcessTerminatedRef.set(event);
            latch.countDown();
        });
        try {
            chromiumProcess.start(options);
        }
        catch (ChromiumProcessStartupFailureException e) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, e);
        }
        try {
            if (!latch.await(600L, TimeUnit.SECONDS)) {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException());
            }
        }
        catch (InterruptedException e) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException("The current thread has been interrupted.", e));
        }
        finally {
            connectionCreated.unsubscribe();
        }
        if (chromiumProcessStartFailedRef.get() != null) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new ChromiumProcessStartupFailureException());
        }
        if ((chromiumProcessTerminated = (ChromiumProcessTerminated)chromiumProcessTerminatedRef.get()) != null) {
            ExitCode exitCode = chromiumProcess.exitCode();
            if (exitCode.equals(ExitCode.USER_DATA_IN_USE)) {
                EngineImpl.throwException(connectionServer, new UserDataDirectoryAlreadyInUseException(userDataDir));
            } else {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new ChromiumProcessStartupFailureException(exitCode));
            }
        }
        Optional<Object> connection = Optional.empty();
        try {
            connection = connectionServer.awaitConnection((ConnectionId)connectionIdRef.get());
            if (!connection.isPresent()) {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException());
            }
        }
        catch (IllegalStateException e) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException());
        }
        ServiceConnectionImpl<EngineFactoryStub> rpc = new ServiceConnectionImpl<EngineFactoryStub>(Protobuf.empty(), (Connection)connection.get(), EngineFactoryStub::new);
        EngineId engineId = EngineId.getDefaultInstance();
        try {
            ImmutableList<StackTraceElement> stackTraceElements = ImmutableList.copyOf(Thread.currentThread().getStackTrace());
            StackTrace stackTrace = new StackTrace(stackTraceElements);
            Logger.debug(() -> "Product binding call stack:" + System.lineSeparator() + stackTrace);
            License license = License.newBuilder().setProductName("JxBrowser").setProductVersion(VersionInfo.version()).setStackTrace(stackTrace.toString()).setKey(licenseKey).build();
            LicenseVerificationStatus status = ((ApplyLicenseResponse)rpc.invoke(rpc.stub()::applyLicense, license)).getStatus();
            if (status == LicenseVerificationStatus.VALID) {
                engineId = (EngineId)rpc.invoke(rpc.stub()::createEngine, Protobuf.empty());
            } else {
                rpc.invokeAsync(rpc.stub()::exit, Protobuf.empty());
                chromiumProcess.close();
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, LicenseExceptionFactory.create(status));
            }
        }
        catch (IllegalStateException e) {
            Logger.debug("The connection has been terminated.");
            chromiumProcess.terminate();
            ExitCode exitCode = chromiumProcess.exitCode();
            if (exitCode.equals(ExitCode.USER_DATA_IN_USE)) {
                EngineImpl.throwException(connectionServer, new UserDataDirectoryAlreadyInUseException(userDataDir));
            }
            if (exitCode.equals(ExitCode.USER_DATA_CREATION_ERROR)) {
                EngineImpl.throwException(connectionServer, new UserDataDirectoryCreationException(userDataDir));
            }
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new ChromiumProcessStartupFailureException(exitCode));
        }
        EngineImpl engine = new EngineImpl((Connection)connection.get(), connectionServer, engineId, options, chromiumProcess);
        engine.on(EngineClosed.class, event -> EngineImpl.cleanUserDataDir(event.engine().options().userDataDir()));
        engine.on(EngineCrashed.class, event -> EngineImpl.cleanUserDataDir(event.engine().options().userDataDir()));
        return engine;
    }

    private EngineImpl(Connection connection, ConnectionServer connectionServer, EngineId engineId, EngineOptions options, ChromiumProcess chromiumProcess) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(connectionServer);
        Preconditions.checkNotNull(engineId);
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(chromiumProcess);
        this.id = engineId;
        this.options = options;
        this.connection = connection;
        this.chromiumProcess = chromiumProcess;
        this.connectionServer = connectionServer;
        this.renderProcesses = new RenderProcesses();
        this.observable = new ObservableHelper();
        this.profiles = new ProfilesImpl(this);
        this.mediaDevices = new Lazy<MediaDevicesImpl>(() -> new MediaDevicesImpl(this));
        this.machService = new Lazy<MachService>(() -> new MachService(this));
        if (Environment.isMac()) {
            this.machService.get().start();
        }
        SharedMemoryManager.newInstance(this);
        this.rpc = new ServiceConnectionImpl<EngineStub>(this.id, connection, EngineStub::new);
        this.chromiumProcessTerminated = chromiumProcess.on(ChromiumProcessTerminated.class, event -> new Thread(this::cleanup).start());
        engineIdToEngineMap.put(this.id, this);
    }

    private static void configureProcessDpiAwareness() {
        if (Environment.isWindows() && SystemProperties.hasProperty("jxbrowser.force.dpi.awareness")) {
            ToolkitLibrary.instance().setProcessDpiAware();
        }
    }

    private static void throwException(ConnectionServer connectionServer, EngineInitializationException exception) {
        connectionServer.close();
        throw exception;
    }

    private static void throwExceptionAndCleanup(Path userDataDir, ConnectionServer connectionServer, EngineInitializationException exception) {
        EngineImpl.cleanUserDataDir(userDataDir);
        EngineImpl.throwException(connectionServer, exception);
    }

    private static void cleanUserDataDir(Path userDataDir) {
        Preconditions.checkNotNull(userDataDir);
        if (tempUserDataDirs.list().contains(userDataDir)) {
            Files.deleteDir(tempUserDataDirs.remove(userDataDir));
        }
    }

    public Connection connection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractChromiumBinariesIfNecessary(Path chromiumDir) {
        if (SystemProperties.hasProperty("jxbrowser.chromium.verification.off")) {
            Logger.debug("Skip verification and extraction: verification is disabled.");
            return;
        }
        List<ChromiumVerifier> verifiers = ChromiumVerifiers.forCurrentPlatform();
        if (verifiers.isEmpty()) {
            Logger.debug("Skip verification and extraction: no verifiers found.");
            return;
        }
        Class<EngineImpl> clazz = EngineImpl.class;
        synchronized (EngineImpl.class) {
            try (FileLock ignored = new FileLock(chromiumDir, EXTRACTION_LOCK_FILE_NAME);){
                if (!EngineImpl.verifyChromiumBinaries(verifiers, chromiumDir)) {
                    ChromiumExtractor.extract(chromiumDir);
                    if (!EngineImpl.verifyChromiumBinaries(verifiers, chromiumDir)) {
                        throw new ChromiumBinariesExtractionException("Failed to verify the extracted Chromium binaries.");
                    }
                }
            }
            catch (AccessDeniedException e) {
                Logger.debug("Skip extraction: the target directory is read-only.");
                if (!EngineImpl.verifyChromiumBinaries(verifiers, chromiumDir)) {
                    throw new ChromiumBinariesExtractionException("Failed to verify Chromium binaries.");
                }
            }
            catch (IOException e) {
                throw new ChromiumBinariesExtractionException("Acquiring an exclusive lock... [FAIL]", e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean verifyChromiumBinaries(List<ChromiumVerifier> verifiers, Path chromiumDir) {
        Logger.debug("Verifying Chromium binaries...");
        for (ChromiumVerifier verifier : verifiers) {
            if (!verifier.verify(chromiumDir)) continue;
            Logger.debug("Verifying Chromium binaries... [OK]");
            return true;
        }
        Logger.debug("Verifying Chromium binaries... [FAIL]");
        return false;
    }

    public ConnectionServer connectionServer() {
        return this.connectionServer;
    }

    public RenderProcesses renderProcesses() {
        return this.renderProcesses;
    }

    public EngineId id() {
        return this.id;
    }

    @Override
    public EngineOptions options() {
        return this.options;
    }

    @Override
    public Browser newBrowser() {
        this.checkNotClosed();
        return this.profiles.defaultProfile().newBrowser();
    }

    @Override
    public List<Browser> browsers() {
        return this.profiles.defaultProfile().browsers();
    }

    @Override
    public ZoomLevels zoomLevels() {
        return this.profiles.defaultProfile().zoomLevels();
    }

    @Override
    public Proxy proxy() {
        return this.profiles.defaultProfile().proxy();
    }

    @Override
    public Network network() {
        return this.profiles.defaultProfile().network();
    }

    @Override
    public SpellChecker spellChecker() {
        return this.profiles.defaultProfile().spellChecker();
    }

    @Override
    public CookieStore cookieStore() {
        return this.profiles.defaultProfile().cookieStore();
    }

    @Override
    public HttpCache httpCache() {
        return this.profiles.defaultProfile().httpCache();
    }

    @Override
    public HttpAuthCache httpAuthCache() {
        return this.profiles.defaultProfile().httpAuthCache();
    }

    @Override
    public MediaDevices mediaDevices() {
        return this.mediaDevices.get();
    }

    @Override
    public Plugins plugins() {
        return this.profiles.defaultProfile().plugins();
    }

    @Override
    public Downloads downloads() {
        return this.profiles.defaultProfile().downloads();
    }

    @Override
    public Permissions permissions() {
        return this.profiles.defaultProfile().permissions();
    }

    @Override
    public ProfilesImpl profiles() {
        return this.profiles;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Logger.debug("Closing engine...");
        this.chromiumProcessTerminated.unsubscribe();
        this.profiles.close();
        if (!this.rpc.isClosed()) {
            this.rpc.invokeAsync(this.rpc.stub()::close, this.id);
        }
        this.cleanup();
        Logger.debug("Closing engine... [OK]");
    }

    private void cleanup() {
        Logger.debug("Cleanup...");
        this.renderProcesses.close();
        this.profiles.cleanup();
        EngineImpl.closeIfNecessary(this.mediaDevices);
        if (Environment.isMac()) {
            EngineImpl.closeIfNecessary(this.machService);
        }
        engineIdToEngineMap.remove(this.id);
        super.close();
        this.awaitProcessTermination();
        this.chromiumProcessTerminated.unsubscribe();
        this.connectionServer.close();
        Logger.debug("Cleanup... [OK]");
    }

    private void awaitProcessTermination() {
        Logger.debug("Awaiting process termination...");
        this.chromiumProcess.close();
        Logger.debug("Awaiting process termination... [OK]");
        ExitCode exitCode = this.chromiumProcess.exitCode();
        if (exitCode.equals(ExitCode.OK)) {
            Logger.debug("Chromium process exit code: {0}", exitCode);
            this.observable.notifyObservers(new EngineClosedImpl(this));
        } else {
            Logger.error("Chromium process exit code: {0}", exitCode);
            this.chromiumProcess.crashDumpDir().ifPresent(crashDumpDir -> Logger.error("Crash dump dir: {0}", crashDumpDir));
            this.observable.notifyObservers(new EngineCrashedImpl(this, exitCode.value()));
        }
    }

    @Override
    public <E extends EngineEvent> Subscription on(Class<E> eventClass, Observer<E> listener) {
        return this.observable.on(eventClass, listener);
    }

    void crash() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::crash, Empty.getDefaultInstance());
    }

    static {
        ClassPreLoader.ensureRequiredClassesLoaded();
        Environment.traceEnvironment();
    }
}

