/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.memory;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.callback.internal.CloseMemoryCallback;
import com.teamdev.jxbrowser.engine.callback.internal.OpenMemoryCallback;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.EngineId;
import com.teamdev.jxbrowser.internal.rpc.MemoryId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionServer;
import com.teamdev.jxbrowser.os.internal.rpc.CloseMemory;
import com.teamdev.jxbrowser.os.internal.rpc.MemoryInfo;
import com.teamdev.jxbrowser.os.internal.rpc.OpenMemory;
import com.teamdev.jxbrowser.os.internal.rpc.SharedMemoryManagerStub;
import java.util.Optional;

public final class SharedMemoryManager {
    private final EngineId engineId;
    private final ToolkitLibrary toolkitLibrary;
    private final ConnectionServer connectionServer;
    private ServiceConnection<SharedMemoryManagerStub> rpc;

    public static SharedMemoryManager newInstance(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        return new SharedMemoryManager(engine);
    }

    private SharedMemoryManager(EngineImpl engine) {
        this.engineId = engine.id();
        this.toolkitLibrary = ToolkitLibrary.instance();
        this.connectionServer = engine.connectionServer();
        this.connectionServer.on(ConnectionCreated.class, this::onConnectionCreated);
        this.connectionServer.getConnection(ConnectionType.GPU).ifPresent(this::onGpuConnectionCreated);
    }

    private void onConnectionCreated(ConnectionCreated event) {
        if (event.connection().type().equals(ConnectionType.GPU)) {
            ConnectionId connectionId = event.connection().id();
            this.connectionServer.awaitConnection(connectionId).ifPresent(this::onGpuConnectionCreated);
        }
    }

    private void onGpuConnectionCreated(Connection connection) {
        this.rpc().ifPresent(Closeable::close);
        this.rpc = new ServiceConnectionImpl<SharedMemoryManagerStub>(this.engineId, connection, SharedMemoryManagerStub::new);
        this.rpc.set(OpenMemoryCallback.class, params -> {
            MemoryInfo memoryInfo = params.getMemoryInfo();
            long memoryId = this.toolkitLibrary.openMemory(memoryInfo.getName(), memoryInfo.getSize());
            return OpenMemory.Response.newBuilder().setId(MemoryId.newBuilder().setValue(memoryId).build()).build();
        });
        this.rpc.set(CloseMemoryCallback.class, params -> {
            this.toolkitLibrary.closeMemory(params.getId().getValue());
            return CloseMemory.Response.getDefaultInstance();
        });
    }

    private Optional<ServiceConnection<SharedMemoryManagerStub>> rpc() {
        return Optional.ofNullable(this.rpc);
    }
}

