/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.DisplayWatcher;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.lang.reflect.Method;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.stage.Window;

public class DisplayWatcher
extends com.teamdev.jxbrowser.internal.DisplayWatcher<NativeAwareWindow> {
    private final ChangeListener<Number> scaleFactorListener;
    private final ChangeListener<Boolean> windowShowingListener;
    private final ChangeListener<Number> windowLocationListener = (property, oldValue, newValue) -> this.notifyWindowStateChanged();
    private NativeAwareWindow window;

    private DisplayWatcher(DisplayWatcher.Observer observer) {
        super(observer);
        this.windowShowingListener = (property, oldValue, newValue) -> this.notifyWindowStateChanged();
        this.scaleFactorListener = (property, oldValue, newValue) -> this.notifyScaleFactorChanged(newValue.doubleValue());
    }

    static DisplayWatcher newInstance(DisplayWatcher.Observer observer) {
        if (HeadlessToolkits.isHeadlessToolkit() || Environment.isLinux()) {
            return new NopDisplayWatcher();
        }
        return new DisplayWatcher(observer);
    }

    public void attach(NativeAwareWindow newWindow) {
        Preconditions.checkNotNull((Object)newWindow);
        if (this.isAttached()) {
            if (this.window.toolkitWindow() != newWindow.toolkitWindow()) {
                throw new IllegalStateException("DisplayWatcher must be detached");
            }
        } else {
            this.window = newWindow;
            this.watchWindow(newWindow);
        }
    }

    public void detach() {
        if (this.isAttached()) {
            this.unwatchWindow(this.window);
            this.window = null;
        }
    }

    void notifyWindowStateChanged() {
        if (this.window == null || !this.window.toolkitWindow().isShowing()) {
            return;
        }
        this.window.findNativeId().ifPresent(windowHandle -> {
            ToolkitLibrary library = ToolkitLibrary.instance();
            String displayId = library.getDisplayIdForWindow(windowHandle.longValue());
            double scaleFactor = library.getScaleFactorForDisplay(displayId);
            this.changeDisplay(displayId, scaleFactor);
        });
    }

    private void watchWindow(NativeAwareWindow window) {
        Window toolkitWindow = window.toolkitWindow();
        toolkitWindow.xProperty().addListener(this.windowLocationListener);
        toolkitWindow.yProperty().addListener(this.windowLocationListener);
        toolkitWindow.showingProperty().addListener(this.windowShowingListener);
        if (!Environment.isJre8()) {
            this.renderScaleXProperty().addListener(this.scaleFactorListener);
            this.renderScaleYProperty().addListener(this.scaleFactorListener);
        }
    }

    private void unwatchWindow(NativeAwareWindow window) {
        Window toolkitWindow = window.toolkitWindow();
        toolkitWindow.xProperty().removeListener(this.windowLocationListener);
        toolkitWindow.yProperty().removeListener(this.windowLocationListener);
        toolkitWindow.showingProperty().removeListener(this.windowShowingListener);
        if (!Environment.isJre8()) {
            this.renderScaleXProperty().removeListener(this.scaleFactorListener);
            this.renderScaleYProperty().removeListener(this.scaleFactorListener);
        }
    }

    private void notifyScaleFactorChanged(double scaleFactor) {
        if (this.window == null || !this.window.toolkitWindow().isShowing()) {
            return;
        }
        this.window.findNativeId().ifPresent(windowHandle -> {
            ToolkitLibrary library = ToolkitLibrary.instance();
            String displayId = library.getDisplayIdForWindowAndScale(windowHandle.longValue(), scaleFactor);
            this.changeDisplay(displayId, scaleFactor);
        });
    }

    private void changeDisplay(String displayId, double deviceScaleFactor) {
        this.changeDisplay(Display.newInstance((String)displayId, (double)deviceScaleFactor));
    }

    private boolean isAttached() {
        return this.window != null;
    }

    private DoubleProperty renderScaleXProperty() {
        return this.doubleProperty("renderScaleXProperty");
    }

    private DoubleProperty renderScaleYProperty() {
        return this.doubleProperty("renderScaleYProperty");
    }

    private DoubleProperty doubleProperty(String methodName) {
        Method property = Methods.getMethod(Window.class, (String)methodName, (Class[])new Class[0]);
        return (DoubleProperty)Methods.invoke((Object)this.window.toolkitWindow(), (Method)property, (Object[])new Object[0]);
    }

    private static final class NopDisplayWatcher
    extends DisplayWatcher {
        private NopDisplayWatcher() {
            super(null);
        }

        @Override
        public void attach(NativeAwareWindow window) {
        }

        @Override
        public void detach() {
        }
    }
}

