/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.browser.internal.Ime;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeTextSpan;
import com.teamdev.jxbrowser.view.javafx.internal.OffScreenRenderWidget;
import java.util.ArrayList;
import javafx.event.EventHandler;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;

final class ImeEventHandler
implements EventHandler<InputMethodEvent> {
    private final OffScreenRenderWidget widget;

    ImeEventHandler(OffScreenRenderWidget widget) {
        this.widget = widget;
    }

    public void handle(InputMethodEvent event) {
        if (!event.getCommitted().isEmpty()) {
            this.widget.widget().ime().commitText(event.getCommitted());
            this.widget.setComposingImeText(false);
        }
        if (!event.getComposed().isEmpty()) {
            StringBuilder composed = new StringBuilder();
            int start = 0;
            int end = 0;
            boolean currectHighlight = false;
            ArrayList<ImeTextSpan> imeTextSpans = new ArrayList<ImeTextSpan>();
            for (InputMethodTextRun run : event.getComposed()) {
                boolean textPartHighlight;
                InputMethodHighlight highlight = run.getHighlight();
                boolean bl = textPartHighlight = highlight == InputMethodHighlight.SELECTED_CONVERTED || highlight == InputMethodHighlight.SELECTED_RAW;
                if (textPartHighlight != currectHighlight) {
                    if (start != end) {
                        imeTextSpans.add(Ime.createTextSpan((int)start, (int)end, (boolean)currectHighlight));
                    }
                    currectHighlight = textPartHighlight;
                    start = end;
                }
                end += run.getText().length();
                composed.append(run.getText());
            }
            if (start != end) {
                imeTextSpans.add(Ime.createTextSpan((int)start, (int)end, (boolean)currectHighlight));
            }
            this.widget.widget().ime().setComposition(composed.toString(), imeTextSpans);
            this.widget.setComposingImeText(true);
        }
    }
}

