/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window;

import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.reflect.AccessibleObjects;
import com.teamdev.jxbrowser.internal.reflect.Classes;
import com.teamdev.jxbrowser.internal.reflect.Fields;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.internal.reflect.ReflectionException;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import java.awt.Window;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import javafx.geometry.Insets;

public final class FxPanel {
    private static final Class<?> AWT_COMPONENT = Classes.forName((String)"java.awt.Component");
    private static final Class<?> AWT_CONTAINER = Classes.forName((String)"java.awt.Container");
    private static final Class<?> AWT_INSETS = Classes.forName((String)"java.awt.Insets");
    private static final Class<?> SWING_UTILITIES = Classes.forName((String)"javax.swing.SwingUtilities");
    private static final Class<?> AWT_POINT = Classes.forName((String)"java.awt.Point");
    private static final Class<?> AWT_WINDOW = Classes.forName((String)"java.awt.Window");
    private static final String EMBEDDED_WINDOW_FQN = "com.sun.javafx.stage.EmbeddedWindow";
    private final Object fxPanel;

    public static Optional<FxPanel> findFor(javafx.stage.Window window) {
        Object outer = FxPanel.getJFxPanel(window).orElse(null);
        if (outer != null && FxPanel.isJfxPanel(outer)) {
            return Optional.of(new FxPanel(outer));
        }
        return Optional.empty();
    }

    private FxPanel(Object fxPanel) {
        this.fxPanel = fxPanel;
    }

    public Point toAwtCoordinates(Point point) {
        Insets insets = this.insets();
        Point locationInWindow = this.locationInWindow();
        int x = (int)((double)point.x() + ((double)locationInWindow.x() + insets.getLeft()));
        int y = (int)((double)point.y() + ((double)locationInWindow.y() + insets.getTop()));
        return Point.of((int)x, (int)y);
    }

    public Insets insets() {
        Method getInsetsMethod = Methods.getMethod(AWT_CONTAINER, (String)"getInsets", (Class[])new Class[0]);
        Object insets = Methods.invoke((Object)this.fxPanel, (Method)getInsetsMethod, (Object[])new Object[0]);
        Field topInsetField = FxPanel.insetsField("top");
        Field bottomInsetField = FxPanel.insetsField("bottom");
        Field leftInsetField = FxPanel.insetsField("left");
        Field rightInsetField = FxPanel.insetsField("right");
        int topInset = (Integer)Fields.value((Object)insets, (Field)topInsetField);
        int rightInset = (Integer)Fields.value((Object)insets, (Field)rightInsetField);
        int bottomInset = (Integer)Fields.value((Object)insets, (Field)bottomInsetField);
        int leftInset = (Integer)Fields.value((Object)insets, (Field)leftInsetField);
        return new Insets((double)topInset, (double)rightInset, (double)bottomInset, (double)leftInset);
    }

    private Point locationInWindow() {
        Method isShowingMethod = FxPanel.componentMethod("isShowing");
        if (!((Boolean)Methods.invoke((Object)this.fxPanel, (Method)isShowingMethod, (Object[])new Object[0])).booleanValue()) {
            return Point.empty();
        }
        Method getParentMethod = FxPanel.componentMethod("getParent");
        Object parent = Methods.invoke((Object)this.fxPanel, (Method)getParentMethod, (Object[])new Object[0]);
        if (parent == null) {
            return Point.empty();
        }
        Object container = FxPanel.topLevelContainerOf(parent);
        Method getLocationMethod = FxPanel.componentMethod("getLocationOnScreen");
        Object locationOnScreen = Methods.invoke((Object)this.fxPanel, (Method)getLocationMethod, (Object[])new Object[0]);
        Method getWindowLocationOnScreenMethod = FxPanel.componentMethod("getLocationOnScreen");
        Object windowLocationOnScreen = Methods.invoke((Object)container, (Method)getWindowLocationOnScreenMethod, (Object[])new Object[0]);
        Field fieldX = Fields.declaredField(AWT_POINT, (String)"x");
        Field fieldY = Fields.declaredField(AWT_POINT, (String)"y");
        int locationOnScreenX = (Integer)Fields.value((Object)locationOnScreen, (Field)fieldX);
        int locationOnScreenY = (Integer)Fields.value((Object)locationOnScreen, (Field)fieldY);
        int windowLocationOnScreenX = (Integer)Fields.value((Object)windowLocationOnScreen, (Field)fieldX);
        int windowLocationOnScreenY = (Integer)Fields.value((Object)windowLocationOnScreen, (Field)fieldY);
        int x = locationOnScreenX - windowLocationOnScreenX;
        int y = locationOnScreenY - windowLocationOnScreenY;
        if (Environment.isMac()) {
            Method getHeight = FxPanel.componentMethod("getHeight");
            int containerHeight = (Integer)Methods.invoke((Object)container, (Method)getHeight, (Object[])new Object[0]);
            int componentHeight = (Integer)Methods.invoke((Object)this.fxPanel, (Method)getHeight, (Object[])new Object[0]);
            y = containerHeight - componentHeight - y;
        }
        return Point.of((int)x, (int)y);
    }

    Optional<Long> awtWindowId() {
        Object awtWindow = this.awtWindow();
        if (awtWindow != null) {
            long handle = AwtHelperLibrary.instance().getWindowHandle((Window)awtWindow);
            return handle == 0L ? Optional.empty() : Optional.of(handle);
        }
        return Optional.empty();
    }

    private Object awtWindow() {
        Method method = Methods.getMethod(SWING_UTILITIES, (String)"getWindowAncestor", (Class[])new Class[]{AWT_COMPONENT});
        return Methods.invokeStatic((Method)method, (Object[])new Object[]{this.fxPanel});
    }

    private static boolean isJfxPanel(Object object) {
        try {
            Class<?> cls = object.getClass();
            return Classes.forName((String)"javafx.embed.swing.JFXPanel").isAssignableFrom(cls);
        }
        catch (ReflectionException e) {
            return false;
        }
    }

    private static Optional<Object> getJFxPanel(javafx.stage.Window window) {
        try {
            Class embeddedWindow = Classes.forName((String)EMBEDDED_WINDOW_FQN);
            if (window.getClass().equals(embeddedWindow)) {
                Object host = FxPanel.getHost(window);
                Field fxPanel = Fields.declaredField(host.getClass(), (String)"this$0");
                AccessibleObjects.makeAccessible((AccessibleObject)fxPanel);
                return Optional.ofNullable(fxPanel.get(host));
            }
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to get embedded outer from {0}, reason: {1}", (Object[])new Object[]{window, e});
        }
        return Optional.empty();
    }

    private static Object getHost(javafx.stage.Window window) {
        Field hostField = Fields.declaredField((String)EMBEDDED_WINDOW_FQN, (String)"host");
        return Fields.value((Object)window, (Field)hostField);
    }

    private static Field insetsField(String fieldName) {
        return Fields.declaredField(AWT_INSETS, (String)fieldName);
    }

    private static Method componentMethod(String methodName) {
        return Methods.getMethod(AWT_COMPONENT, (String)methodName, (Class[])new Class[0]);
    }

    private static Object topLevelContainerOf(Object container) {
        Method method = FxPanel.componentMethod("getParent");
        Object parent = Methods.invoke((Object)container, (Method)method, (Object[])new Object[0]);
        if (parent == null || AWT_WINDOW.isAssignableFrom(parent.getClass())) {
            return container;
        }
        return FxPanel.topLevelContainerOf(parent);
    }
}

