/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.internal.window.BeaconWindow;
import com.teamdev.jxbrowser.view.javafx.internal.window.FxPanel;
import com.teamdev.jxbrowser.view.javafx.internal.window.reflection.PlatformWindow;
import java.util.Optional;
import javafx.event.EventHandler;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public final class NativeAwareWindow {
    private static final long NO_ID = 0L;
    private final Window window;
    private final EventHandler<WindowEvent> windowHiddenHandler;
    private long nativeId;

    public static NativeAwareWindow newInstance(Window window) {
        Preconditions.checkNotNull((Object)window);
        return new NativeAwareWindow(window);
    }

    private NativeAwareWindow(Window window) {
        this.window = window;
        this.nativeId = 0L;
        this.windowHiddenHandler = event -> {
            this.nativeId = 0L;
        };
        window.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
    }

    public Window toolkitWindow() {
        return this.window;
    }

    public void focusNatively() {
        Preconditions.checkState((boolean)Environment.isWindows());
        if (this.window.isShowing() && this.window.isFocused()) {
            ToolkitLibrary.instance().focusHWND(this.nativeId());
        }
    }

    public long nativeId() {
        Optional<Long> nativeId = this.findNativeId();
        if (!nativeId.isPresent() || nativeId.get() == 0L) {
            throw new IllegalStateException("Failed to get native widget ID");
        }
        return nativeId.get();
    }

    public Optional<Long> findNativeId() {
        if (this.nativeId == 0L) {
            this.discoverNativeId().ifPresent(id -> {
                this.nativeId = id;
            });
        }
        return Optional.of(this.nativeId);
    }

    public void removeEventListeners() {
        this.window.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
    }

    private Optional<Long> discoverNativeId() {
        if (!this.window.isShowing()) {
            Logger.debug((String)"Window must be showing to get its native id");
            return Optional.empty();
        }
        Optional<Long> awtWindowHandle = FxPanel.findFor(this.window).flatMap(FxPanel::awtWindowId);
        if (awtWindowHandle.isPresent()) {
            return awtWindowHandle;
        }
        if (this.isScalingSupportLimited() || SystemProperties.hasProperty((String)"jxbrowser.javafx.legacy.handle")) {
            return this.getHandleFromInternalApi();
        }
        return BeaconWindow.findOwnerId(this.window);
    }

    private Optional<Long> getHandleFromInternalApi() {
        Optional<PlatformWindow> platformWindow = PlatformWindow.from(this.window);
        if (Environment.isMac()) {
            return platformWindow.flatMap(PlatformWindow::getNativeView);
        }
        if (Environment.isWindows() && Environment.isJre8()) {
            return platformWindow.flatMap(PlatformWindow::getNativeHandle);
        }
        return platformWindow.flatMap(PlatformWindow::getNativeWindow);
    }

    private boolean isScalingSupportLimited() {
        return Environment.isJre8();
    }
}

