/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.internal.ProcessDpiAwareness;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class ChromiumProcessWin
extends ChromiumProcess {
    static final String PROCESS_NAME = "chromium.exe";

    ChromiumProcessWin(int port, Path chromiumDir) {
        super(port, chromiumDir, PROCESS_NAME);
    }

    @Override
    protected Optional<String> defaultCrashDumpDir() {
        AtomicReference defaultDir = new AtomicReference();
        Environment.win32UserAppDataLocalDir().ifPresent(appDataDir -> defaultDir.set(appDataDir.resolve("JxBrowser").resolve(VersionInfo.version()).resolve("CrashReports").toAbsolutePath().toString()));
        return Optional.ofNullable((String)defaultDir.get());
    }

    @Override
    protected Collection<String> platformCommandLineArgs(EngineOptions engineOptions) {
        ChromiumSwitches switches = new ChromiumSwitches();
        this.dpiAwarenessFlag().ifPresent(switches::add);
        switches.add("disable-fill-background");
        switches.add("disable-direct-composition");
        return switches.toList();
    }

    private Optional<String> dpiAwarenessFlag() {
        int awareness = ToolkitLibrary.instance().getProcessDpiAwareness();
        ProcessDpiAwareness dpiAwareness = ProcessDpiAwareness.from(awareness);
        if (dpiAwareness == null) {
            return Optional.empty();
        }
        return Optional.of("dpi-awareness=" + (Object)((Object)dpiAwareness));
    }
}

