/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.ChromiumVerifier;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierLinux;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierMac;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierWin32;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierWin64;
import com.teamdev.jxbrowser.os.Environment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ChromiumVerifiers {
    private ChromiumVerifiers() {
    }

    public static List<ChromiumVerifier> forCurrentPlatform() {
        Optional<ChromiumFiles> chromiumFiles;
        ArrayList<ChromiumVerifier> result = new ArrayList<ChromiumVerifier>();
        if (Environment.isMac()) {
            chromiumFiles = Environment.isArm() ? ChromiumFiles.listForMacArm() : ChromiumFiles.listForMac();
            chromiumFiles.ifPresent(files -> result.add(new ChromiumVerifierMac((ChromiumFiles)files)));
        }
        if (Environment.isLinux()) {
            chromiumFiles = Environment.isArm() ? ChromiumFiles.listForLinuxArm() : ChromiumFiles.listForLinux64();
            chromiumFiles.ifPresent(files -> result.add(new ChromiumVerifierLinux((ChromiumFiles)files)));
        }
        if (Environment.isWindows()) {
            if (Environment.isWindows64()) {
                ChromiumFiles.listForWin64().ifPresent(files -> result.add(new ChromiumVerifierWin64((ChromiumFiles)files)));
            }
            ChromiumFiles.listForWin32().ifPresent(files -> result.add(new ChromiumVerifierWin32((ChromiumFiles)files)));
        }
        return result;
    }
}

