/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.DirectoryCreationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public final class Files {
    private Files() {
    }

    public static void createDirs(Path path) {
        if (!java.nio.file.Files.exists(path, new LinkOption[0])) {
            try {
                java.nio.file.Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DirectoryCreationException(path, (Throwable)e);
            }
        }
    }

    public static void deleteDir(Path path) {
        File dir = path.toFile();
        if (!dir.isDirectory()) {
            if (!dir.delete()) {
                dir.deleteOnExit();
            }
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    Files.deleteDir(file.toPath());
                }
            }
            Files.deleteFile(dir.toPath());
        }
    }

    public static void deleteFile(Path path) {
        File file = path.toFile();
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static Path createTempDir(String prefix) {
        try {
            return java.nio.file.Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new DirectoryCreationException("Failed to create temporary directory.", (Throwable)e);
        }
    }

    public static void restorePermissionsForFile(Path path) throws IOException {
        File file = path.toFile();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canExecute() && !file.setExecutable(true, false)) {
            throw new IOException("Failed to update permissions for file: " + file.getAbsolutePath());
        }
    }

    public static Optional<Path> findFileWithPrefix(Path directoryPath, String prefix) {
        File[] files;
        File directory = directoryPath.toFile();
        if (directory.isDirectory() && (files = directory.listFiles((dir, name) -> name.startsWith(prefix))) != null && files.length > 0) {
            return Optional.of(files[0].toPath());
        }
        return Optional.empty();
    }

    static void validateDirectory(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("The " + dir.getAbsolutePath() + " directory does not exist and cannot be created.");
        }
        if (!dir.isDirectory()) {
            throw new IOException("The " + dir.getAbsolutePath() + " path does not refer to a directory.");
        }
        if (!Files.canWriteToDirectory(dir.getAbsolutePath())) {
            throw new IOException("There is no write permission to the " + dir.getAbsolutePath() + " directory.");
        }
    }

    private static boolean canWriteToDirectory(String dirPath) {
        long time = System.currentTimeMillis();
        String tempFile = dirPath + File.separator + "jxbrowser-test-file-" + time;
        File file = new File(tempFile);
        try {
            new FileOutputStream(file, true).close();
            file.delete();
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }
}

