/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryTransport;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class RpcThreadImpl
extends CloseableImpl
implements RpcThread {
    private static final IdMap<Long, RpcThreadImpl> rpcThreads = new IdMap();
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final Map<Object, TaskRunner> taskRunners = new ConcurrentHashMap<Object, TaskRunner>();
    private final TaskRunner mainTaskRunner = new TaskRunner();
    private final Thread thread;

    public static Optional<RpcThreadImpl> forCurrentThread() {
        return rpcThreads.find(Thread.currentThread().getId());
    }

    public RpcThreadImpl(SharedMemoryTransport transport) {
        this.thread = new Thread(this.mainTaskRunner::processTasks, String.format("%s: %s", RpcThreadImpl.threadName(transport.type()), transport.id()));
        rpcThreads.put(this.thread.getId(), this);
        this.thread.start();
        Logger.debug("RPC thread started: id = {0}, type = {1}", this.thread.getId(), transport.type());
    }

    private static String threadName(ConnectionType type) {
        if (type == ConnectionType.BROWSER) {
            return "Browser Thread";
        }
        if (type == ConnectionType.GPU) {
            return "GPU Thread";
        }
        if (type == ConnectionType.RENDER) {
            return "Render Thread";
        }
        throw new IllegalArgumentException(String.format("The connection type is not supported: %s", type));
    }

    @Override
    public void close() {
        Logger.debug("Closing RPC thread...");
        rpcThreads.remove(this.thread.getId());
        this.taskRunners.values().forEach(CloseableImpl::close);
        this.mainTaskRunner.close();
        super.close();
        Logger.debug("Closing RPC thread... [OK]");
    }

    @Override
    public boolean isCurrentlyOn() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public void submit(Runnable task) {
        Preconditions.checkState(!this.isClosed());
        Preconditions.checkNotNull(task);
        if (!this.queue.add(task)) {
            Logger.error("Submitting task to RPC thread queue... [FAIL]");
            throw new IllegalStateException("Failed to submit a task to RPC thread queue");
        }
    }

    @Override
    public <T> T execute(Callable<T> task) throws ExecutionException {
        FutureTask<T> futureTask = new FutureTask<T>(task);
        this.submit(futureTask);
        while (!this.isClosed()) {
            try {
                if (futureTask.isDone()) {
                    return futureTask.get();
                }
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    @Override
    public RpcThread.TaskRunner enterNestedLoop(Object key) {
        Logger.debug("Entering nested loop...");
        Preconditions.checkState(!this.isClosed());
        TaskRunner taskRunner = new TaskRunner();
        this.taskRunners.put(key, taskRunner);
        return taskRunner;
    }

    @Override
    public void exitNestedLoop(Object key) {
        Logger.debug("Exiting nested loop...");
        Preconditions.checkState(!this.isClosed());
        Preconditions.checkState(this.taskRunners.containsKey(key));
        TaskRunner taskRunner = this.taskRunners.remove(key);
        taskRunner.close();
    }

    private final class TaskRunner
    extends CloseableImpl
    implements RpcThread.TaskRunner {
        private TaskRunner() {
        }

        @Override
        public void close() {
            super.close();
            if (RpcThreadImpl.this.queue.isEmpty()) {
                RpcThreadImpl.this.submit(() -> {});
            }
        }

        @Override
        public void processTasks() {
            RpcThreadImpl rpcThread = RpcThreadImpl.this;
            Preconditions.checkState(rpcThread.isCurrentlyOn(), "The task runner must only be run on the RPC thread.");
            while (!this.isClosed()) {
                try {
                    ((Runnable)RpcThreadImpl.this.queue.take()).run();
                }
                catch (InterruptedException e) {
                    Logger.error("The current thread has been interrupted.", e);
                    this.close();
                }
                catch (Throwable e) {
                    Thread currentThread = Thread.currentThread();
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = currentThread.getUncaughtExceptionHandler();
                    uncaughtExceptionHandler.uncaughtException(currentThread, e);
                    Logger.error("Failed to process task.", e);
                }
            }
        }
    }
}

