/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream;

import com.teamdev.jxbrowser.callback.AsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.SyncCallback;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.Threads;
import com.teamdev.jxbrowser.internal.reflect.Constructors;
import com.teamdev.jxbrowser.internal.reflect.Types;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.Status;
import com.teamdev.jxbrowser.internal.rpc.StreamData;
import com.teamdev.jxbrowser.internal.rpc.StreamMessage;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.stream.util.ActionType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.CallbackType;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class CallbackStream
extends Stream {
    private final AtomicReference<Callback> callbackRef = new AtomicReference();
    private final AtomicReference<Class> callbackClassRef = new AtomicReference();

    public CallbackStream(Service service, Descriptors.MethodDescriptor method, Message targetId, Connection connection) {
        super(service, method, targetId, connection);
    }

    @Override
    public synchronized void setInterceptor(Interceptor interceptor) {
        this.checkNotClosed();
        if (!this.isSubscribed()) {
            this.openStream();
            this.subscribe();
        }
        super.setInterceptor(interceptor);
    }

    public synchronized <C extends Callback> C set(Class<C> callbackClass, C callback) {
        this.checkNotClosed();
        if (!this.isSubscribed()) {
            this.openStream();
            this.subscribe();
        }
        this.callbackClassRef.set(callbackClass);
        return (C)this.callbackRef.getAndSet(callback);
    }

    public synchronized <C extends Callback> C get() {
        this.checkNotClosed();
        return (C)this.callbackRef.get();
    }

    public synchronized <C extends Callback> C remove() {
        this.checkNotClosed();
        this.callbackClassRef.set(null);
        Callback callback = this.callbackRef.getAndSet(null);
        if (!this.interceptor().isPresent()) {
            this.unsubscribe();
            this.complete();
        }
        return (C)callback;
    }

    private synchronized boolean isSubscribed() {
        return this.callbackClassRef.get() != null && this.callbackRef.get() != null || this.interceptor().isPresent();
    }

    @Override
    protected StreamData createSubscriptionRequest(Stream.Subscription subscription) {
        Message requestPrototype = this.service().requestPrototype(this.method());
        Descriptors.Descriptor requestDescriptor = requestPrototype.getDescriptorForType();
        Descriptors.FieldDescriptor subscribeField = requestDescriptor.findFieldByName("subscribe");
        Descriptors.FieldDescriptor targetField = requestDescriptor.findFieldByName("target");
        Message message = requestPrototype.toBuilder().setField(subscribeField, subscription == Stream.Subscription.SUBSCRIBE).setField(targetField, this.targetId()).build();
        return StreamData.newBuilder().setMessage(StreamMessage.newBuilder().setBytes(message.toByteString()).build()).setStatus(Status.OK).build();
    }

    private void error(StreamMessage message) {
        this.write(StreamData.newBuilder().setStatus(Status.FAILED).setMessage(message).build());
    }

    private void complete() {
        this.write(StreamData.newBuilder().setStatus(Status.OK).setCloseStream(Empty.newBuilder().build()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(StreamData data) {
        block19: {
            if (this.isClosed()) {
                return;
            }
            try {
                Message message = this.service().responsePrototype(this.method()).newBuilderForType().mergeFrom(data.getMessage().getBytes()).build();
                Descriptors.Descriptor descriptor = message.getDescriptorForType();
                Descriptors.FieldDescriptor paramsField = descriptor.findFieldByName("request");
                Descriptors.FieldDescriptor responseField = descriptor.findFieldByName("response");
                Object params = message.getField(paramsField);
                Interceptor.Action action = this.interceptor().map(interceptor -> interceptor.intercept((Message)params)).orElse(Interceptor.Action.PROCEED);
                if (action == Interceptor.Action.PROCEED) {
                    Class callbackClass = this.callbackClassRef.get();
                    Callback callback = this.callbackRef.get();
                    if (callbackClass == null || callback == null) {
                        CallbackStream callbackStream = this;
                        synchronized (callbackStream) {
                            if (this.isSubscribed()) {
                                this.error(data.getMessage());
                            }
                        }
                        return;
                    }
                    Consumer<Message> done = response -> {
                        CallbackStream callbackStream = this;
                        synchronized (callbackStream) {
                            if (!this.isSubscribed()) {
                                return;
                            }
                            this.write(data.toBuilder().setMessage(data.getMessage().toBuilder().setBytes(message.toBuilder().setField(responseField, response).build().toByteString()).build()).build());
                        }
                    };
                    if (AsyncCallback.class.isAssignableFrom(callbackClass)) {
                        AsyncCallback asyncCallback = (AsyncCallback)callback;
                        Class actionClass = ActionType.from(CallbackType.of(callbackClass)).type();
                        Constructor<?> constructor = Constructors.getConstructor(actionClass, Consumer.class);
                        AsyncCallbackAction responder = (AsyncCallbackAction)Types.newInstance(constructor, done);
                        asyncCallback.on(params, responder);
                    } else {
                        SyncCallback syncCallback = (SyncCallback)callback;
                        done.accept((Message)syncCallback.on(params));
                    }
                    break block19;
                }
                CallbackStream callbackStream = this;
                synchronized (callbackStream) {
                    if (this.isSubscribed()) {
                        this.error(data.getMessage());
                    }
                }
            }
            catch (Throwable t) {
                CallbackStream callbackStream = this;
                synchronized (callbackStream) {
                    if (this.isSubscribed()) {
                        this.error(data.getMessage());
                    }
                }
                Threads.reportException(t);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.isSubscribed()) {
            this.resetInterceptor();
            this.remove();
        }
        super.close();
    }
}

