/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallExecutor;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import java.util.concurrent.atomic.AtomicReference;

final class RpcThreadCallExecutor
implements RpcCallExecutor {
    private final RpcThread rpcThread;

    RpcThreadCallExecutor(RpcThread rpcThread) {
        this.rpcThread = rpcThread;
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> ResponseT execute(RequestT request, ServiceMethod<RequestT, ResponseT> method) {
        Object key = new Object();
        RpcThread.TaskRunner taskRunner = this.rpcThread.enterNestedLoop(key);
        SharedMemoryController controller = new SharedMemoryController();
        AtomicReference exceptionRef = new AtomicReference();
        AtomicReference responseRef = new AtomicReference();
        method.run(controller, request, response -> {
            if (controller.failed()) {
                exceptionRef.set(new IllegalStateException(controller.errorText()));
            } else {
                responseRef.set(response);
            }
            this.rpcThread.exitNestedLoop(key);
        });
        taskRunner.processTasks();
        if (exceptionRef.get() != null) {
            throw new IllegalStateException("Failed to receive the response.", (Throwable)exceptionRef.get());
        }
        return (ResponseT)((Message)responseRef.get());
    }
}

