/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.js.JsException;
import com.teamdev.jxbrowser.js.JsPromise;
import com.teamdev.jxbrowser.js.JsPromiseHandler;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.CatchHandler;
import com.teamdev.jxbrowser.js.internal.rpc.FinallyHandler;
import com.teamdev.jxbrowser.js.internal.rpc.JsPromiseStub;
import com.teamdev.jxbrowser.js.internal.rpc.ReturnValue;
import com.teamdev.jxbrowser.js.internal.rpc.ThenHandler;

public final class JsPromiseImpl
extends JsObjectImpl
implements JsPromise {
    private final ServiceConnectionImpl<JsPromiseStub> rpc;

    public JsPromiseImpl(JsContext jsContext, JsObjectId jsObjectId) {
        super(jsContext, jsObjectId);
        this.rpc = new ServiceConnectionImpl<JsPromiseStub>(jsObjectId, jsContext.connection(), JsPromiseStub::new);
    }

    @Override
    public JsPromise then(JsPromiseHandler onFulfilled, JsPromiseHandler onRejected) {
        this.checkNotClosed();
        Preconditions.checkNotNull(onFulfilled);
        Preconditions.checkNotNull(onRejected);
        ThenHandler request = ThenHandler.newBuilder().setPromiseId(this.objectId()).setFulfillmentHandlerId(this.functionCallbackId(onFulfilled)).setRejectionHandlerId(this.functionCallbackId(onRejected)).build();
        ReturnValue response = (ReturnValue)this.rpc.invoke(this.rpc.stub()::then, request);
        return this.convertedJsPromise(response);
    }

    @Override
    public JsPromise then(JsPromiseHandler onFulfilled) {
        this.checkNotClosed();
        Preconditions.checkNotNull(onFulfilled);
        ThenHandler request = ThenHandler.newBuilder().setPromiseId(this.objectId()).setFulfillmentHandlerId(this.functionCallbackId(onFulfilled)).build();
        ReturnValue response = (ReturnValue)this.rpc.invoke(this.rpc.stub()::then, request);
        return this.convertedJsPromise(response);
    }

    @Override
    public JsPromise finallyExecute(JsPromiseHandler onFinally) {
        this.checkNotClosed();
        Preconditions.checkNotNull(onFinally);
        FinallyHandler request = FinallyHandler.newBuilder().setPromiseId(this.objectId()).setHandlerId(this.functionCallbackId(onFinally)).build();
        ReturnValue response = (ReturnValue)this.rpc.invoke(this.rpc.stub()::executeFinally, request);
        return this.convertedJsPromise(response);
    }

    @Override
    public JsPromise catchError(JsPromiseHandler onRejected) {
        this.checkNotClosed();
        Preconditions.checkNotNull(onRejected);
        CatchHandler request = CatchHandler.newBuilder().setPromiseId(this.objectId()).setHandlerId(this.functionCallbackId(onRejected)).build();
        ReturnValue response = (ReturnValue)this.rpc.invoke(this.rpc.stub()::catchError, request);
        return this.convertedJsPromise(response);
    }

    private JsPromise convertedJsPromise(ReturnValue response) {
        if (response.getValueCase() == ReturnValue.ValueCase.JS_VALUE) {
            return (JsPromise)JavaValue.from(response.getJsValue()).toObject();
        }
        throw new JsException(response.getJsError().getMessage());
    }

    private JsObjectProxyId functionCallbackId(JsPromiseHandler functionCallback) {
        return JsValue.from(this.jsContext(), functionCallback).impl().getFunctionCallbackId();
    }
}

