/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.internal.mac;

import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.browser.internal.AccessibilityNode;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class NsAccessibility
extends AccessibilityNode {
    private final ToolkitLibrary toolkit;
    private final BrowserWidget browserWidget;
    private Subscription focusGained;
    private Subscription focusLost;
    private long parentNsViewId;

    public NsAccessibility(BrowserWidget browserWidget) {
        Preconditions.checkNotNull(browserWidget);
        this.toolkit = ToolkitLibrary.instance();
        this.browserWidget = browserWidget;
    }

    @Override
    public void add(long parentViewId, long viewId) {
        this.parentNsViewId = parentViewId;
        this.browserWidget.accessibilityToken().ifPresent(token -> {
            this.toolkit.addAccessibilityNode(parentViewId, token.getAccessibilityNode().getDataList(), token.getProcessId());
            com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode windowNode = this.accessibilityNode(parentViewId);
            com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode viewNode = this.accessibilityNode(viewId);
            this.browserWidget.setParentAccessibilityNodes(windowNode, viewNode);
        });
        BrowserImpl browser = this.browserWidget.browser();
        this.focusGained = browser.on(FocusGained.class, focusGained -> this.activateRemoteAccessibilityNode());
        this.focusLost = browser.on(FocusLost.class, focusLost -> this.deactivateRemoteAccessibilityNode());
    }

    @Override
    public void remove() {
        this.toolkit.removeAccessibilityNode(this.parentNsViewId);
        if (this.focusGained != null) {
            this.focusGained.unsubscribe();
        }
        if (this.focusLost != null) {
            this.focusLost.unsubscribe();
        }
    }

    private void activateRemoteAccessibilityNode() {
        this.toolkit.activateAccessibilityNode(this.parentNsViewId);
    }

    private void deactivateRemoteAccessibilityNode() {
        this.toolkit.deactivateAccessibilityNode(this.parentNsViewId);
    }

    private com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode accessibilityNode(long nsViewId) {
        AccessibilityNode.Builder builder = com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode.newBuilder();
        int[] token = this.toolkit.getAccessibilityNode(nsViewId);
        if (token != null) {
            builder.addAllData(Arrays.stream(token).boxed().collect(Collectors.toList()));
        }
        return builder.build();
    }
}

