/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.DisplayWatcher;
import com.teamdev.jxbrowser.internal.ScaleFactor;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

class DisplayWatcher
extends com.teamdev.jxbrowser.internal.DisplayWatcher<Window> {
    private Window window;
    private final WindowListener windowListener = new WindowListener();
    private final List<String> chromiumSwitches;

    private DisplayWatcher(DisplayWatcher.Observer observer, List<String> chromiumSwitches) {
        super(observer);
        this.chromiumSwitches = new ArrayList<String>(chromiumSwitches);
    }

    static DisplayWatcher newInstance(DisplayWatcher.Observer observer, List<String> chromiumSwitches) {
        if (HeadlessToolkits.isHeadlessToolkit() || Environment.isLinux()) {
            return new NopDisplayWatcher();
        }
        return new DisplayWatcher(observer, chromiumSwitches);
    }

    private void notifyWindowStateChanged() {
        if (this.window != null) {
            long windowHandle = AwtHelperLibrary.instance().getWindowHandle(this.window);
            String displayId = ToolkitLibrary.instance().getDisplayIdForWindow(windowHandle);
            double scaleFactor = this.forcedScaleFactor().orElse(this.scaleFactor(displayId));
            this.changeDisplay(Display.newInstance((String)displayId, (double)scaleFactor));
        }
    }

    public void attach(Window window) {
        if (window != null) {
            this.window = window;
            window.addComponentListener(this.windowListener);
            this.notifyWindowStateChanged();
        }
    }

    public void detach() {
        if (this.window != null) {
            this.window.removeComponentListener(this.windowListener);
        }
    }

    private Optional<Double> forcedScaleFactor() {
        return ScaleFactor.fromChromiumSwitches(this.chromiumSwitches);
    }

    private double scaleFactor(String displayId) {
        return ToolkitLibrary.instance().getScaleFactorForDisplay(displayId);
    }

    private final class WindowListener
    extends ComponentAdapter {
        private WindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DisplayWatcher.this.notifyWindowStateChanged();
        }
    }

    public static final class NopDisplayWatcher
    extends DisplayWatcher {
        private NopDisplayWatcher() {
            super(null, Collections.emptyList());
        }

        @Override
        public void attach(Window window) {
        }

        @Override
        public void detach() {
        }
    }
}

