/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.ObjectClosedException;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.Lazy;
import java.util.concurrent.atomic.AtomicBoolean;

public class CloseableImpl
implements Closeable {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected static void closeIfNecessary(Lazy<? extends Closeable> target) {
        Preconditions.checkNotNull(target);
        target.maybeGet().ifPresent(Closeable::close);
    }

    protected final void checkNotClosed() {
        if (this.isClosed()) {
            throw new ObjectClosedException();
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.closed.set(true);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed.get();
    }
}

