/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.Sets;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.PageContext;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.CloseableMap;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.internal.rpc.PageContextId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.js.internal.JsAccessibleMethod;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObject;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObjects;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class JsContext
extends CloseableImpl {
    private final FrameImpl frame;
    private final PageContext pageContext;
    private final JsAccessibleObjects jsAccessibleObjects;
    private final CloseableMap<JsObjectId, JsObjectImpl> jsObjects;

    private JsContext(FrameImpl frame, PageContext pageContext) {
        this.frame = frame;
        this.jsObjects = CloseableMap.wrap(new ConcurrentHashMap());
        this.pageContext = pageContext;
        this.jsAccessibleObjects = new JsAccessibleObjects();
    }

    public static JsContext of(PageContextId pageContextId) {
        return Optional.ofNullable(PageContext.of(pageContextId)).map(PageContext::jsContext).orElseThrow(IllegalStateException::new);
    }

    public static JsContext newInstance(FrameImpl frame, PageContext pageContext) {
        Preconditions.checkNotNull(frame);
        Preconditions.checkNotNull(pageContext);
        return new JsContext(frame, pageContext);
    }

    public void registerJsObject(JsObjectImpl jsObject) {
        this.jsObjects.put(jsObject.objectId(), jsObject);
    }

    public <T> Optional<T> findJsObject(JsObjectId id, Class<T> objectType) {
        JsObjectImpl jsObject = (JsObjectImpl)this.jsObjects.get(id);
        if (jsObject != null) {
            Preconditions.checkState(objectType.isAssignableFrom(jsObject.getClass()));
        }
        return Optional.ofNullable(jsObject);
    }

    public FrameImpl frame() {
        return this.frame;
    }

    PageContext pageContext() {
        return this.pageContext;
    }

    @Override
    public void close() {
        this.jsObjects.forEach((jsObjectId, jsObject) -> jsObject.makeClosed());
        this.jsAccessibleObjects.close();
        super.close();
    }

    public void onObjectClosed(JsObjectId id) {
        this.jsObjects.remove(id);
    }

    public Optional<JsAccessibleObject> jsAccessibleObject(JsObjectProxyId proxyId) {
        return this.jsAccessibleObjects.getJavaObject(proxyId);
    }

    JsObjectProxyId registerObject(Object object) {
        return this.registerJavaObject(object, false);
    }

    JsObjectProxyId registerFunction(Object object) {
        return this.registerJavaObject(object, true);
    }

    private JsObjectProxyId registerJavaObject(Object object, boolean isFunction) {
        return this.jsAccessibleObjects.getId(object).orElseGet(() -> {
            JsObjectProxyId id;
            if (isFunction) {
                id = this.frame.createJsProxyFunction();
            } else {
                JsAccessibleObject accessibleObject = new JsAccessibleObject(object);
                Set<String> fields = this.fieldNames(accessibleObject);
                Sets.SetView<String> methods = Sets.difference(this.methodNames(accessibleObject), fields);
                id = this.frame.createJsProxyObject(fields, methods);
            }
            this.jsAccessibleObjects.add(id, object);
            return id;
        });
    }

    public Connection connection() {
        return this.frame.renderProcess().connection();
    }

    private Set<String> methodNames(JsAccessibleObject object) {
        return object.accessibleMethods().stream().map(JsAccessibleMethod::name).collect(Collectors.toSet());
    }

    private Set<String> fieldNames(JsAccessibleObject object) {
        return object.accessibleFields().stream().map(Field::getName).collect(Collectors.toSet());
    }
}

