/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.UInt64Value;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.js.JsSet;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsSetRequest;
import com.teamdev.jxbrowser.js.internal.rpc.JsSetStub;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValues;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class JsSetImpl
extends JsObjectImpl
implements JsSet {
    private final ServiceConnectionImpl<JsSetStub> rpc;

    public JsSetImpl(JsContext jsContext, JsObjectId jsObjectId) {
        super(jsContext, jsObjectId);
        this.rpc = new ServiceConnectionImpl<JsSetStub>(this.objectId(), jsContext.connection(), JsSetStub::new);
    }

    @Override
    public JsSet add(@Nullable Object element) {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::add, this.requestFrom(element));
        return this;
    }

    @Override
    public boolean has(@Nullable Object key) {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::has, this.requestFrom(key))).getValue();
    }

    @Override
    public boolean delete(Object key) {
        Preconditions.checkNotNull(key);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::delete, this.requestFrom(key))).getValue();
    }

    @Override
    public long size() {
        this.checkNotClosed();
        return ((UInt64Value)this.rpc.invoke(this.rpc.stub()::size, this.objectId())).getValue();
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::clear, this.objectId());
    }

    private JsSetRequest requestFrom(@Nullable Object key) {
        return JsSetRequest.newBuilder().setObjectId(this.objectId()).setKey(this.toJsValue(key)).build();
    }

    @Override
    public Set<Object> toSet() {
        this.checkNotClosed();
        long size = this.size();
        Preconditions.checkState(size <= Integer.MAX_VALUE, "The array size exceeds the maximum size of a set.");
        LinkedHashSet set = new LinkedHashSet((int)size);
        JsValues values = (JsValues)this.rpc.invoke(this.rpc.stub()::getItems, this.objectId());
        InputStream inputStream = values.getSerializedValues().newInput();
        try {
            while (inputStream.available() > 0) {
                JsValue jsValue = JsValue.parseDelimitedFrom(inputStream);
                set.add(JavaValue.from(jsValue).toObject());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to convert the array to list.", e);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public <T> Set<T> toSet(Class<T> type) {
        Preconditions.checkNotNull(type);
        this.checkNotClosed();
        long size = this.size();
        Preconditions.checkState(size <= Integer.MAX_VALUE, "The array size exceeds the maximum size of a set.");
        LinkedHashSet set = new LinkedHashSet((int)size);
        JsValues values = (JsValues)this.rpc.invoke(this.rpc.stub()::getItems, this.objectId());
        InputStream inputStream = values.getSerializedValues().newInput();
        try {
            while (inputStream.available() > 0) {
                JsValue jsValue = JsValue.parseDelimitedFrom(inputStream);
                set.add(JavaValue.from(jsValue).toObject(type));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to convert the JS set to Java set.", e);
        }
        return Collections.unmodifiableSet(set);
    }
}

