/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.tls;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.net.tls.X509Certificates;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface Certificate {
    public static Certificate of(X509Certificate x509Cert) throws CertificateEncodingException {
        return Certificate.of(x509Cert, Collections.emptyList());
    }

    public static Certificate of(X509Certificate x509Cert, List<X509Certificate> intermediateX509Certs) throws CertificateEncodingException {
        Preconditions.checkNotNull(x509Cert);
        Preconditions.checkNotNull(intermediateX509Certs);
        ArrayList<com.teamdev.jxbrowser.net.internal.rpc.Certificate> certs = new ArrayList<com.teamdev.jxbrowser.net.internal.rpc.Certificate>();
        for (X509Certificate intermediateX509Cert : intermediateX509Certs) {
            certs.add(com.teamdev.jxbrowser.net.internal.rpc.Certificate.cast(Certificate.of(intermediateX509Cert)));
        }
        return com.teamdev.jxbrowser.net.internal.rpc.Certificate.newBuilder().setDerEncodedValue(ByteString.copyFrom(x509Cert.getEncoded())).addAllIntermediateCerts(certs).build();
    }

    default public byte[] derEncodedValue() {
        return com.teamdev.jxbrowser.net.internal.rpc.Certificate.cast(this).getDerEncodedValue().toByteArray();
    }

    @Immutable
    default public List<Certificate> intermediateCertificates() {
        return com.teamdev.jxbrowser.net.internal.rpc.Certificate.cast(this).getIntermediateCertsList().stream().map(certificate -> certificate).collect(ImmutableList.toImmutableList());
    }

    default public Optional<X509Certificate> toX509Certificate() {
        try {
            return Optional.of(X509Certificates.of(new ByteArrayInputStream(this.derEncodedValue())));
        }
        catch (CertificateException ignore) {
            return Optional.empty();
        }
    }
}

