/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.spellcheck.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.spellcheck.Language;
import com.teamdev.jxbrowser.spellcheck.LanguageNotAvailableException;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.spellcheck.internal.DictionaryImpl;
import com.teamdev.jxbrowser.spellcheck.internal.SpellcheckLanguage;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.AddLanguageRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.LanguagesList;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.RemoveLanguageRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SetSpellCheckEnabledRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SpellCheckerStub;
import java.util.List;

public final class SpellCheckerImpl
extends CloseableImpl
implements SpellChecker {
    private final ProfileImpl profile;
    private final Lazy<DictionaryImpl> customDictionary;
    private final ServiceConnectionImpl<SpellCheckerStub> rpc;

    public SpellCheckerImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.customDictionary = new Lazy<DictionaryImpl>(() -> new DictionaryImpl(this));
        this.rpc = new ServiceConnectionImpl<SpellCheckerStub>(profile.id(), engine.connection(), SpellCheckerStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public boolean isEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::getEnabled, this.profile.id())).getValue();
    }

    private void setEnabled(boolean enabled) {
        this.checkNotClosed();
        SetSpellCheckEnabledRequest request = SetSpellCheckEnabledRequest.newBuilder().setProfileId(this.profile.id()).setEnabled(BoolValue.of(enabled)).build();
        this.rpc.invoke(this.rpc.stub()::setEnabled, request);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public List<Language> languages() {
        this.checkNotClosed();
        return ((LanguagesList)this.rpc.invoke(this.rpc.stub()::getLanguages, this.profile.id())).getLanguageList().stream().map(SpellcheckLanguage::toPublic).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addLanguage(Language language) {
        Preconditions.checkNotNull(language);
        this.checkNotClosed();
        if (Environment.isMac()) {
            this.checkDictionaryPresence(language);
            return;
        }
        AddLanguageRequest request = AddLanguageRequest.newBuilder().setProfileId(this.profile.id()).setDictionaryName(language.toString()).build();
        boolean success = ((BoolValue)this.rpc.invoke(this.rpc.stub()::addLanguage, request)).getValue();
        if (!success) {
            throw new LanguageNotAvailableException(language);
        }
    }

    @Override
    public void removeLanguage(Language language) {
        Preconditions.checkNotNull(language);
        this.checkNotClosed();
        if (Environment.isMac()) {
            return;
        }
        RemoveLanguageRequest request = RemoveLanguageRequest.newBuilder().setProfileId(this.profile.id()).setDictionaryName(language.toString()).build();
        this.rpc.invoke(this.rpc.stub()::removeLanguage, request);
    }

    private void checkDictionaryPresence(Language language) {
        Preconditions.checkState(Environment.isMac());
        List<Language> availableLanguages = this.languages();
        if (!availableLanguages.contains(language)) {
            throw new LanguageNotAvailableException(language);
        }
    }

    @Override
    public Dictionary customDictionary() {
        return this.customDictionary.get();
    }

    @Override
    public void close() {
        SpellCheckerImpl.closeIfNecessary(this.customDictionary);
        this.rpc.close();
        super.close();
    }
}

