/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TakeFocusCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.TakeFocus;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.LinuxFocusAdapter;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.TabbingAssistant;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidget;
import com.teamdev.jxbrowser.view.swt.internal.WindowsFocusAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

abstract class FocusAdapter {
    private final Listener whenFocusedIn;
    private final Listener whenShellDeactivated;
    private final WindowedWidget windowedWidget;
    private final TabbingAssistant tabbingAssistant;
    private boolean started;
    private Subscription focusGained;
    private Subscription focusLost;

    FocusAdapter(WindowedWidget windowedWidget) {
        this.windowedWidget = windowedWidget;
        this.whenFocusedIn = this::onSwtWidgetFocusedIn;
        this.whenShellDeactivated = this::onShellDeactivated;
        this.tabbingAssistant = new TabbingAssistant(windowedWidget.getParent());
    }

    static FocusAdapter newInstance(WindowedWidget jxComposite) {
        if (Environment.isLinux()) {
            return new LinuxFocusAdapter(jxComposite);
        }
        if (Environment.isWindows()) {
            return new WindowsFocusAdapter(jxComposite);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    final void startEventProcessing() {
        Display display = this.windowedWidget.getDisplay();
        display.addFilter(15, this.whenFocusedIn);
        display.addFilter(27, this.whenShellDeactivated);
        BrowserWidget browserWidget = this.windowedWidget.browserWidget();
        browserWidget.set(TakeFocusCallback.class, (BrowserWidgetCallback)((TakeFocusCallback)params -> {
            SafeExecutor.asyncExec((Widget)this.windowedWidget, () -> {
                if (params.getFocusNextComponent()) {
                    this.tabbingAssistant.passFocusToNext();
                } else {
                    this.tabbingAssistant.passFocusToPrev();
                }
            });
            return TakeFocus.Response.newBuilder().setTake(Protobuf.empty()).build();
        }));
        BrowserImpl browser = browserWidget.browser();
        this.focusGained = browser.on(FocusGained.class, this::on);
        this.focusLost = browser.on(FocusLost.class, this::on);
        this.started = true;
    }

    final void stopEventProcessing() {
        if (this.started) {
            Display display = this.windowedWidget.getDisplay();
            display.removeFilter(15, this.whenFocusedIn);
            display.removeFilter(27, this.whenShellDeactivated);
            this.focusGained.unsubscribe();
            this.focusLost.unsubscribe();
            this.windowedWidget.browserWidget().remove(TakeFocusCallback.class);
        }
        this.started = false;
    }

    protected abstract void on(FocusLost var1);

    protected abstract void on(FocusGained var1);

    protected abstract void onSwtWidgetFocusedIn(Event var1);

    WindowedWidget windowedWidget() {
        return this.windowedWidget;
    }

    private void onShellDeactivated(Event event) {
        if (this.windowedWidget.isDisposed()) {
            return;
        }
        Widget deactivatedWidget = event.widget;
        if (this.windowedWidget.getShell().equals(deactivatedWidget)) {
            this.windowedWidget.unfocusBrowserWidget();
        }
    }
}

