/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateWebDialogLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateWebDialogSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateDialogLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateDialogSurface;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

final class IoSurfaceWebDialogView {
    private final NsView nsView;
    private final JComponent parent;

    IoSurfaceWebDialogView(BrowserWidget widget, JComponent parent, WebDialog dialog) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)dialog);
        this.parent = parent;
        this.nsView = new NsView(widget);
        dialog.set(UpdateWebDialogSurfaceCallback.class, (WebDialogCallback)((UpdateWebDialogSurfaceCallback)params -> {
            this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor(), true);
            return UpdateDialogSurface.Response.newBuilder().build();
        }));
        dialog.set(UpdateWebDialogLayerCallback.class, (WebDialogCallback)((UpdateWebDialogLayerCallback)params -> {
            this.nsView.setNsViewLayer(params.getContextId(), params.getScaleFactor(), true);
            return UpdateDialogLayer.Response.newBuilder().build();
        }));
        dialog.on(DialogBoundsUpdated.class, event -> this.nsView.updateBounds(this.centeredRelativeToWindowRect((Rect)event.getBounds())));
        dialog.on(DialogClosed.class, event -> SwingUtilities.invokeLater(() -> {
            this.nsView.close();
            dialog.browser().widget().focus();
        }));
    }

    private Rect centeredRelativeToWindowRect(Rect bounds) {
        Window window = SwingUtilities.getWindowAncestor(this.parent);
        java.awt.Point windowLocationOnScreen = window.getLocationOnScreen();
        java.awt.Point parentLocationOnScreen = this.parent.getLocationOnScreen();
        java.awt.Point parentLocationOnWindow = new java.awt.Point(parentLocationOnScreen.x - windowLocationOnScreen.x, parentLocationOnScreen.y - windowLocationOnScreen.y);
        Dimension parentSize = this.parent.getSize();
        Dimension windowSize = window.getSize();
        Point origin = bounds.origin();
        int x = origin.x() + parentLocationOnWindow.x;
        int y = windowSize.height - (parentLocationOnWindow.y + parentSize.height) + (parentSize.height - (bounds.y() + bounds.height()));
        return Rect.of((int)x, (int)y, (int)bounds.width(), (int)bounds.height());
    }

    void show(long parentNsViewId, Rect initialBounds) {
        this.nsView.show(parentNsViewId, this.centeredRelativeToWindowRect(initialBounds));
    }
}

