/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.ShowDropdownCallback;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.DefaultCallbacks;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.platform.win.MessageLoopHelper;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.DragAndDrop;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultAlertCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultBeforeFormRepostCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultBeforeUnloadCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultConfirmCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenExternalAppCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenFileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenFilesCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenFolderCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenPopupCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultPrintCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultPromptCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultRequestPdfDocumentPasswordCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveAsPdfCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveCreditCardCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSavePasswordCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveUserDataProfileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSelectClientCertificateCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSelectColorCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultShowContextMenuCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultShowDropdownCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultStartCaptureSessionCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultStartDownloadCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultUpdatePasswordCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultUpdateUserDataProfileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.internal.DefaultShowSuggestionsCallback;
import com.teamdev.jxbrowser.view.javafx.internal.BrowserNode;
import com.teamdev.jxbrowser.view.javafx.internal.Graphics2dRenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.IoSurfaceRenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.WindowedWidget;
import com.teamdev.jxbrowser.view.javafx.internal.menu.SuggestionsListener;
import javafx.application.Platform;
import javafx.scene.layout.StackPane;

public final class BrowserView
extends StackPane {
    private static final int GTK_VERSION_2 = 2;
    private final BrowserImpl browser;
    private final DragAndDrop dragAndDrop;
    private final DefaultCallbacks<BrowserCallback> defaultCallbacks;
    private Subscription onBrowserClosed;
    private final RenderingMode renderingMode;
    private final BrowserNode browserNode;

    public static BrowserView newInstance(Browser browser) {
        BrowserView.checkEnvironment();
        return new BrowserView(browser);
    }

    private BrowserView(Browser browser) {
        Preconditions.checkNotNull((Object)browser);
        Logger.debug((String)"UI Toolkit: JavaFX");
        this.browser = (BrowserImpl)browser;
        this.renderingMode = browser.engine().options().renderingMode();
        if (MessageLoopHelper.isSupported((RenderingMode)this.renderingMode)) {
            MessageLoopHelper.markAsMessageLoopThread();
        }
        this.defaultCallbacks = this.defaultCallbacks();
        this.browserNode = this.createChildNode(this.widget());
        this.getChildren().add((Object)this.browserNode.asNode());
        SuggestionsListener suggestionsListener = new SuggestionsListener(browser);
        this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
            this.defaultCallbacks.unregister();
            Platform.runLater(() -> this.getChildren().remove((Object)this.browserNode.asNode()));
            this.onBrowserClosed.unsubscribe();
            suggestionsListener.stopEventsProcessing();
            this.unregisterCustomDropdownIfNecessary();
        });
        this.dragAndDrop = new DragAndDropSupport();
        suggestionsListener.startEventsProcessing();
        this.defaultCallbacks.register();
    }

    private BrowserWidget widget() {
        return this.browser.widget();
    }

    private DefaultCallbacks<BrowserCallback> defaultCallbacks() {
        this.registerCustomDropdownIfNecessary();
        return DefaultCallbacks.of((Advisable)this.browser).add((Callback)((CreatePopupCallback)params -> CreatePopupCallback.Response.create())).add((Callback)new DefaultOpenPopupCallback()).add((Callback)new DefaultAlertCallback(this)).add((Callback)new DefaultConfirmCallback(this)).add((Callback)new DefaultPromptCallback(this)).add((Callback)new DefaultOpenFileCallback(this)).add((Callback)new DefaultOpenFilesCallback(this)).add((Callback)new DefaultOpenFolderCallback(this)).add((Callback)new DefaultSaveAsPdfCallback(this)).add((Callback)new DefaultSelectColorCallback(this)).add((Callback)new DefaultBeforeUnloadCallback(this)).add((Callback)new DefaultSelectClientCertificateCallback(this)).add((Callback)new DefaultBeforeFormRepostCallback(this)).add((Callback)new DefaultPrintCallback()).add((Callback)new DefaultShowContextMenuCallback(this)).add((Callback)new DefaultStartDownloadCallback(this)).add((Callback)new DefaultStartCaptureSessionCallback()).add((Callback)new DefaultOpenExternalAppCallback(this)).add((Callback)new DefaultShowSuggestionsCallback(this)).add((Callback)new DefaultSavePasswordCallback(this)).add((Callback)new DefaultUpdatePasswordCallback(this)).add((Callback)new DefaultSaveCreditCardCallback(this)).add((Callback)new DefaultSaveUserDataProfileCallback(this)).add((Callback)new DefaultUpdateUserDataProfileCallback(this)).add((Callback)new DefaultRequestPdfDocumentPasswordCallback(this)).build();
    }

    private void registerCustomDropdownIfNecessary() {
        if (this.isCustomDropdownsEnabled()) {
            this.widget().set(ShowDropdownCallback.class, (BrowserWidgetCallback)new DefaultShowDropdownCallback(this));
        }
    }

    private void unregisterCustomDropdownIfNecessary() {
        if (this.isCustomDropdownsEnabled()) {
            this.browser.widget().remove(ShowDropdownCallback.class);
        }
    }

    private boolean isCustomDropdownsEnabled() {
        return HeadlessToolkits.isHeadlessToolkit() && this.renderingMode == RenderingMode.OFF_SCREEN;
    }

    private BrowserNode createChildNode(BrowserWidget widget) {
        if (this.renderingMode == RenderingMode.OFF_SCREEN) {
            return new Graphics2dRenderWidget(widget);
        }
        if (this.renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
            if (Environment.isMac()) {
                return new IoSurfaceRenderWidget(widget);
            }
            if (Environment.isWindows() || Environment.isLinux()) {
                return new WindowedWidget(widget);
            }
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.browserNode != null) {
            this.browserNode.asNode().requestFocus();
        }
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop;
    }

    private static void checkEnvironment() {
        if (Environment.isLinux()) {
            int gtkVersion = SystemProperties.getAsInt((String)"jdk.gtk.version", (int)Integer.MAX_VALUE);
            Preconditions.checkState((gtkVersion != 2 ? 1 : 0) != 0, (Object)String.format("Unsupported GTK version: %d.", gtkVersion));
        }
    }

    private class DragAndDropSupport
    implements DragAndDrop {
        private DragAndDropSupport() {
        }

        @Override
        public void enable() {
            BrowserView.this.browser.dragAndDrop().enable();
            if (BrowserView.this.browserNode != null) {
                BrowserView.this.browserNode.enableDragAndDrop();
            }
        }

        @Override
        public void disable() {
            if (BrowserView.this.browserNode != null) {
                BrowserView.this.browserNode.disableDragAndDrop();
            }
            BrowserView.this.browser.dragAndDrop().disable();
        }

        @Override
        public boolean isEnabled() {
            return BrowserView.this.browser.dragAndDrop().isEnabledSync();
        }
    }
}

