/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import java.util.Optional;
import org.eclipse.swt.widgets.Composite;

final class EclipseWorkbenchDetector {
    private static final String CONTRIBUTED_PART_RENDERER = "ContributedPartRenderer";

    private EclipseWorkbenchDetector() {
    }

    static boolean inEclipseWorkbench(Composite composite) {
        return EclipseWorkbenchDetector.findContributedPartRenderer(composite).isPresent();
    }

    static Optional<Composite> findContributedPartRenderer(Composite composite) {
        for (Composite parent = composite.getParent(); parent != null; parent = parent.getParent()) {
            Class<?> parentClass = parent.getClass();
            if (!EclipseWorkbenchDetector.isPartRenderer(parentClass)) continue;
            return Optional.of(parent);
        }
        return Optional.empty();
    }

    private static boolean isPartRenderer(Class<?> parentClass) {
        return parentClass.isAnonymousClass() && parentClass.getEnclosingClass().getSimpleName().equals(CONTRIBUTED_PART_RENDERER);
    }
}

