/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

final class FocusCauseTracker
implements Listener {
    private static final int EVENT_FILTER = 31;
    private final BrowserComposite widget;
    private int focusCause = 0;

    FocusCauseTracker(BrowserComposite widget) {
        this.widget = widget;
    }

    public void handleEvent(Event event) {
        if (event.type == 31 && (event.detail == 16 || event.detail == 8)) {
            this.focusCause = event.detail;
        } else if (event.type == 15 && event.widget != this.widget) {
            this.focusCause = 0;
        }
    }

    FocusRequest.Cause getFocusCause() {
        if (this.focusCause == 16) {
            return FocusRequest.Cause.TRAVERSAL_FORWARD;
        }
        if (this.focusCause == 8) {
            return FocusRequest.Cause.TRAVERSAL_BACKWARD;
        }
        return FocusRequest.Cause.FOCUS_CASE_UNSPECIFIED;
    }

    void register() {
        this.widget.getDisplay().addFilter(EVENT_FILTER, (Listener)this);
    }

    void unregister() {
        this.widget.getDisplay().removeFilter(EVENT_FILTER, (Listener)this);
    }
}

