/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateSurface;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.IoSurfaceWebDialogView;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

final class IoSurfaceRenderWidget
extends OffScreenRenderWidget {
    private final NsView nsView;

    IoSurfaceRenderWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, widget);
        this.nsView = new NsView(widget);
        BrowserImpl browser = widget.browser();
        widget.set(CreateWebDialogCallback.class, (BrowserWidgetCallback)((CreateWebDialogCallback)params -> {
            WebDialog webDialog = new WebDialog(browser, params.getWebDialogId());
            IoSurfaceWebDialogView webDialogView = new IoSurfaceWebDialogView(this.browserWidget(), (Composite)this, webDialog);
            long nsViewId = this.nativeHandle();
            SafeExecutor.asyncExec((Widget)this, () -> webDialogView.show(nsViewId, (Rect)params.getInitialBounds()));
            return CreateWebDialog.Response.newBuilder().build();
        }));
        EngineImpl engine = browser.engine();
        EngineOptions engineOptions = engine.options();
        if (engineOptions.renderingMode() == RenderingMode.OFF_SCREEN) {
            widget.set(PaintCallback.class, (BrowserWidgetCallback)((PaintCallback)params -> {
                PaintRequest request = params.getPaintRequest();
                this.nsView.updateSurface((Size)request.getViewSize(), request.getScaleFactor(), request.getMemoryId(), false);
                widget.onPainted();
                return Paint.Response.newBuilder().build();
            }));
        } else {
            widget.set(UpdateSurfaceCallback.class, (BrowserWidgetCallback)((UpdateSurfaceCallback)params -> {
                this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor());
                return UpdateSurface.Response.newBuilder().build();
            }));
            widget.set(UpdateLayerCallback.class, (BrowserWidgetCallback)((UpdateLayerCallback)params -> {
                this.nsView.setNsViewLayer(params.getContextId(), params.getScaleFactor());
                return UpdateLayer.Response.newBuilder().build();
            }));
        }
        this.showRenderWidget();
    }

    @Override
    protected void close() {
        this.browserWidget().remove(CreateWebDialogCallback.class);
        this.nsView.close();
        super.close();
    }

    @Override
    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        super.showRenderWidget();
        Rectangle bounds = this.getBounds();
        this.nsView.show(this.nativeHandle(), Rect.of((int)bounds.width, (int)bounds.height));
        this.browserWidget().attach(0L);
    }

    @Override
    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        this.nsView.hide();
        super.hideRenderWidget();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        if (this.nsView != null) {
            this.nsView.updateBounds(Rect.of((int)r.x, (int)r.y, (int)r.width, (int)r.height));
        }
    }
}

