/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.Ime;
import com.teamdev.jxbrowser.browser.internal.NativeKeyboardListener;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TakeFocusCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeCompositionCancelled;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeTextSpan;
import com.teamdev.jxbrowser.browser.internal.rpc.TakeFocus;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.ui.ToolkitKey;
import com.teamdev.jxbrowser.internal.ui.ToolkitKeyCodes;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyLocation;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.ui.internal.KeyCodes;
import com.teamdev.jxbrowser.ui.internal.KeyEvents;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.EclipsePartVisibilityTracker;
import com.teamdev.jxbrowser.view.swt.internal.EclipseWorkbenchDetector;
import com.teamdev.jxbrowser.view.swt.internal.FocusCauseTracker;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareShell;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.SwtCursorFactory;
import com.teamdev.jxbrowser.view.swt.internal.SwtKey;
import com.teamdev.jxbrowser.view.swt.internal.SwtKeyCodes;
import com.teamdev.jxbrowser.view.swt.internal.SwtMouseButton;
import com.teamdev.jxbrowser.view.swt.internal.TabbingAssistant;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragAndDropSupport;
import com.teamdev.jxbrowser.view.swt.internal.menu.SuggestionsPopup;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Widget;

public abstract class OffScreenRenderWidget
extends BrowserComposite
implements NativeAwareControl {
    final MouseListener mouseListener;
    final MouseWheelListener mouseWheelListener;
    final MouseMotionListener mouseMoveListener;
    final MouseTrackListener mouseTrackListener;
    final KeyListener keyListener;
    final NativeKeyboardListener nativeKeyboardListener;
    private final FocusListener focusListener;
    private final FocusCauseTracker focusCauseTracker;
    private final ControlListener resizeListener;
    private final Subscription browserClosing;
    private final SwtCursorFactory cursorFactory;
    private final ToolkitKeyCodes<SwtKey> keyCodes = SwtKeyCodes.instance();
    private final TabbingAssistant tabbingAssistant;
    private final DragAndDropSupport dragAndDropSupport;
    private EclipsePartVisibilityTracker eclipsePartVisibilityTracker;
    private Subscription cursorChanged;
    private Subscription tooltipChanged;
    private boolean visible;
    private IME ime;
    private boolean isComposingImeText;
    private Subscription compositionCancelled;

    OffScreenRenderWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, 262144, widget);
        this.keyListener = new KeyListener();
        this.mouseListener = new MouseListener();
        this.focusCauseTracker = new FocusCauseTracker(this);
        this.focusListener = new FocusListener(this.focusCauseTracker);
        this.resizeListener = new ResizeListener();
        this.mouseWheelListener = new MouseWheelListener();
        this.mouseMoveListener = new MouseMotionListener();
        this.mouseTrackListener = new MouseTrackListener();
        this.nativeKeyboardListener = NativeKeyboardListener.create((BrowserWidget)widget, this::interceptNativeKeyEvent);
        this.tabbingAssistant = new TabbingAssistant(parent);
        this.cursorFactory = SwtCursorFactory.forDevice((Device)this.getDisplay());
        this.initializeIme();
        this.addTraverseListener(e -> {
            e.doit = false;
        });
        this.addDisposeListener(e -> {
            this.hideRenderWidget();
            this.close();
        });
        if (EclipseWorkbenchDetector.inEclipseWorkbench((Composite)this)) {
            this.eclipsePartVisibilityTracker = this.createEclipseVisibilityTracker();
            this.eclipsePartVisibilityTracker.start();
        }
        this.dragAndDropSupport = DragAndDropSupport.newInstance(this);
        BrowserImpl browser = widget.browser();
        this.browserClosing = browser.on(BrowserClosing.class, event -> SafeExecutor.asyncExec((Widget)this, this::close));
    }

    private void interceptNativeKeyEvent(NativeKeyEvent keyEvent) {
        BrowserId id;
        Optional<SuggestionsPopup> popup;
        int winEnterKeyCode = 13;
        int unixEnterKeyCode = 36;
        boolean isEnter = false;
        if (Environment.isWindows()) {
            isEnter = keyEvent.getWinKey().getWParam() == 13L;
        } else if (Environment.isMac()) {
            isEnter = keyEvent.getMacKey().getKeyCode() == 36;
        } else if (Environment.isLinux()) {
            boolean bl = isEnter = keyEvent.getLinuxKey().getKeyCode() == 36;
        }
        if (isEnter && (popup = SuggestionsPopup.fromBrowser(id = this.browserWidget().browser().id())).isPresent()) {
            return;
        }
        SafeExecutor.asyncExec((Widget)this, () -> this.browserWidget().dispatch(keyEvent));
    }

    private void initializeIme() {
        this.ime = new IME((Canvas)this, 0);
        this.isComposingImeText = false;
        this.ime.addListener(43, event -> {
            switch (event.detail) {
                case 1: {
                    this.handleCompositionChanged(event);
                    break;
                }
                case 3: {
                    this.handleCompositionSelection(event);
                    break;
                }
                default: {
                    event.doit = true;
                }
            }
        });
        this.setIME(this.ime);
        Caret caret = new Caret((Canvas)this, 0);
        caret.setLocation(-1, -1);
        this.setCaret(caret);
        this.compositionCancelled = this.browserWidget().ime().on(ImeCompositionCancelled.class, event -> this.endImeComposition());
    }

    private void endImeComposition() {
        if (Environment.isWindows() || Environment.isMac()) {
            ToolkitLibrary.instance().endImeComposition(this.nativeHandle());
        }
    }

    private void handleCompositionSelection(Event event) {
        event.text = this.browserWidget().ime().getSelectedText();
        event.doit = false;
    }

    @Override
    protected void close() {
        if (this.wasInEclipseWorkbenchLastTime()) {
            this.eclipsePartVisibilityTracker.stop();
        }
        this.unregisterListeners();
        this.cursorFactory.disposeCursors();
        this.browserClosing.unsubscribe();
        this.compositionCancelled.unsubscribe();
        super.close();
    }

    @Override
    protected void onHierarchyChanged() {
        super.onHierarchyChanged();
        if (this.stillInEclipseWorkbench()) {
            this.eclipsePartVisibilityTracker.reattach();
        } else if (EclipseWorkbenchDetector.inEclipseWorkbench((Composite)this)) {
            this.eclipsePartVisibilityTracker = this.createEclipseVisibilityTracker();
            this.eclipsePartVisibilityTracker.start();
        } else if (this.wasInEclipseWorkbenchLastTime()) {
            this.eclipsePartVisibilityTracker.stop();
            this.eclipsePartVisibilityTracker = null;
        }
    }

    private EclipsePartVisibilityTracker createEclipseVisibilityTracker() {
        return EclipsePartVisibilityTracker.newBuilder(this).showListener(e -> this.showRenderWidget()).hideListener(e -> this.hideRenderWidget()).build();
    }

    private boolean stillInEclipseWorkbench() {
        return this.wasInEclipseWorkbenchLastTime() && EclipseWorkbenchDetector.inEclipseWorkbench((Composite)this);
    }

    private boolean wasInEclipseWorkbenchLastTime() {
        return this.eclipsePartVisibilityTracker != null;
    }

    final boolean isShown() {
        return this.visible;
    }

    @Override
    void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        if (this.isFocusControl() && Environment.isWindows()) {
            this.browserWidget().focus();
        }
        this.browserWidget().browser().dragAndDrop().ifEnabled(this.dragAndDropSupport::enable);
        this.registerListeners();
        BrowserWidget widget = this.browserWidget();
        widget.assignHostWindow(this.nativeAwareShell().nativeHandle());
        widget.show();
        this.notifyBoundsUpdated();
        this.visible = true;
    }

    @Override
    void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        this.dragAndDropSupport.disable();
        this.unregisterListeners();
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.hide();
        }
        this.visible = false;
    }

    private void unregisterListeners() {
        if (this.cursorChanged != null) {
            this.cursorChanged.unsubscribe();
        }
        if (this.tooltipChanged != null) {
            this.tooltipChanged.unsubscribe();
        }
        this.browserWidget().remove(TakeFocusCallback.class);
        this.removeKeyListener();
        this.removeControlListener(this.resizeListener);
        this.removeFocusListener((org.eclipse.swt.events.FocusListener)this.focusListener);
        this.focusCauseTracker.unregister();
        this.removeWindowListeners();
        this.removeMouseListeners();
    }

    private void registerListeners() {
        BrowserWidget widget = this.browserWidget();
        this.cursorChanged = widget.on(CursorChanged.class, event -> {
            try {
                SafeExecutor.asyncExec((Widget)this, () -> this.setCursor((Cursor)this.cursorFactory.newCursor((CursorChanged)event)));
            }
            catch (Exception e) {
                Logger.error((String)"Failed to change cursor", (Throwable)e);
            }
        });
        this.tooltipChanged = widget.on(TooltipChanged.class, event -> SafeExecutor.asyncExec((Widget)this, () -> {
            String text = event.getTooltipText();
            if (text.isEmpty()) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(text);
            }
        }));
        widget.set(TakeFocusCallback.class, (BrowserWidgetCallback)((TakeFocusCallback)params -> {
            SafeExecutor.asyncExec((Widget)this, () -> {
                if (params.getFocusNextComponent()) {
                    this.tabbingAssistant.passFocusToNext();
                } else {
                    this.tabbingAssistant.passFocusToPrev();
                }
            });
            return TakeFocus.Response.newBuilder().setTake(Protobuf.empty()).build();
        }));
        this.addWindowListeners();
        this.addMouseListeners();
        this.addKeyListener();
        this.addFocusListener((org.eclipse.swt.events.FocusListener)this.focusListener);
        this.focusCauseTracker.register();
        this.addControlListener(this.resizeListener);
    }

    private void addKeyListener() {
        if (Boolean.getBoolean("jxbrowser.use.native.keyboard.input")) {
            Optional<Long> windowId = this.getNativeHandleForKeyboardListener();
            if (windowId.isPresent()) {
                this.nativeKeyboardListener.start(windowId.get().longValue(), this.isFocusControl());
            } else {
                Logger.warn((String)"Failed to find the native window handle. Falling back to Java keyboard input.");
                this.addKeyListener((org.eclipse.swt.events.KeyListener)this.keyListener);
            }
        } else {
            this.addKeyListener((org.eclipse.swt.events.KeyListener)this.keyListener);
        }
    }

    private Optional<Long> getNativeHandleForKeyboardListener() {
        long windowId = Environment.isLinux() ? this.nativeAwareShell().nativeHandle() : this.nativeHandle();
        if (windowId != 0L) {
            return Optional.of(windowId);
        }
        return Optional.empty();
    }

    private void removeKeyListener() {
        if (this.nativeKeyboardListener.isActive()) {
            this.nativeKeyboardListener.stop();
        } else {
            this.removeKeyListener((org.eclipse.swt.events.KeyListener)this.keyListener);
        }
    }

    private void addWindowListeners() {
        this.shellListeners().attach(this.getShell());
        this.displayWatcher().attach(this.nativeAwareShell());
    }

    private NativeAwareShell nativeAwareShell() {
        return new NativeAwareShell(this.getShell());
    }

    private void removeWindowListeners() {
        this.shellListeners().detach();
        this.displayWatcher().detach();
    }

    private void addMouseListeners() {
        this.addMouseListener((org.eclipse.swt.events.MouseListener)this.mouseListener);
        this.addMouseMoveListener(this.mouseMoveListener);
        this.addMouseTrackListener((org.eclipse.swt.events.MouseTrackListener)this.mouseTrackListener);
        this.addMouseWheelListener(this.mouseWheelListener);
    }

    private void removeMouseListeners() {
        this.removeMouseListener((org.eclipse.swt.events.MouseListener)this.mouseListener);
        this.removeMouseMoveListener(this.mouseMoveListener);
        this.removeMouseTrackListener((org.eclipse.swt.events.MouseTrackListener)this.mouseTrackListener);
        this.removeMouseWheelListener(this.mouseWheelListener);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.notifyBoundsUpdated();
    }

    @Override
    void notifyBoundsUpdated() {
        Point location = this.toDisplay(0, 0);
        Rectangle bounds = this.getBounds();
        Rect boundsInParent = Geometry.newRect((double)bounds.x, (double)bounds.y, (double)bounds.width, (double)bounds.height);
        Rect boundsInScreen = Geometry.newRect((double)location.x, (double)location.y, (double)bounds.width, (double)bounds.height);
        if (!boundsInParent.size().isEmpty()) {
            this.browserWidget().bounds(boundsInParent, boundsInScreen);
        }
    }

    @Override
    public void enableDragAndDrop() {
        this.dragAndDropSupport.enable();
    }

    @Override
    public void disableDragAndDrop() {
        this.dragAndDropSupport.disable();
    }

    public FocusListener focusListener() {
        return this.focusListener;
    }

    private void dispatchMouseDragged(MouseEvent event) {
        Optional<MouseButton> mouseButton = this.draggedMouseButton(event);
        if (!mouseButton.isPresent()) {
            return;
        }
        this.browserWidget().dispatch(MouseDragged.newBuilder((com.teamdev.jxbrowser.ui.Point)this.localPoint(event)).locationOnScreen(this.screenPoint(event)).button(mouseButton.get()).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(this.keyModifiers(event)).build());
        if (this.dragAndDropSupport.isBrowserDragHappening()) {
            Event dragEvent = new Event();
            dragEvent.type = 29;
            dragEvent.display = this.getDisplay();
            dragEvent.widget = this;
            dragEvent.button = event.button;
            dragEvent.stateMask = event.stateMask;
            dragEvent.time = event.time;
            dragEvent.x = event.x;
            dragEvent.y = event.y;
            this.notifyListeners(29, dragEvent);
        }
    }

    private Optional<MouseButton> draggedMouseButton(MouseEvent event) {
        if ((event.stateMask & 0x80000) != 0) {
            return Optional.of(MouseButton.PRIMARY);
        }
        if ((event.stateMask & 0x100000) != 0) {
            return Optional.of(MouseButton.MIDDLE);
        }
        if ((event.stateMask & 0x200000) != 0) {
            return Optional.of(MouseButton.SECONDARY);
        }
        return Optional.empty();
    }

    private KeyModifiers keyModifiers(KeyEvent e) {
        return KeyModifiers.newBuilder().altDown(this.isAltDown(e)).altGraphDown(this.isAltGraphDown(e)).shiftDown(this.isShiftDown(e)).controlDown(this.isControlDown(e)).metaDown(this.isMetaDown(e)).build();
    }

    private KeyModifiers keyModifiers(MouseEvent event) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder().altDown(this.isAltDown(event)).altGraphDown(false).shiftDown(this.isShiftDown(event)).controlDown(this.isControlDown(event)).metaDown(this.isMetaDown(event));
        return builder.build();
    }

    private KeyLocation keyLocation(KeyEvent e) {
        if (e.keyLocation == 2) {
            return KeyLocation.NUMERIC_KEYPAD;
        }
        if (e.keyLocation == 16384) {
            return KeyLocation.LEFT;
        }
        if (e.keyLocation == 131072) {
            return KeyLocation.RIGHT;
        }
        return KeyLocation.STANDARD;
    }

    private boolean isMetaDown(MouseEvent event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isMetaDown(KeyEvent event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isControlDown(MouseEvent event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isControlDown(KeyEvent event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isShiftDown(MouseEvent event) {
        return (event.stateMask & 0x20000) != 0;
    }

    private boolean isShiftDown(KeyEvent event) {
        return (event.stateMask & 0x20000) != 0;
    }

    private boolean isAltGraphDown(KeyEvent event) {
        return this.isAltDown(event) && this.keyLocation(event) == KeyLocation.RIGHT;
    }

    private boolean isAltDown(MouseEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private boolean isAltDown(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private static MouseModifiers mouseModifiers(MouseEvent event) {
        return MouseModifiers.newBuilder().primaryButtonDown(OffScreenRenderWidget.hasModifier(event, 524288) || OffScreenRenderWidget.isPressed(event, MouseButton.PRIMARY)).middleButtonDown(OffScreenRenderWidget.hasModifier(event, 0x100000) || OffScreenRenderWidget.isPressed(event, MouseButton.MIDDLE)).secondaryButtonDown(OffScreenRenderWidget.hasModifier(event, 0x200000) || OffScreenRenderWidget.isPressed(event, MouseButton.SECONDARY)).build();
    }

    private static boolean hasModifier(MouseEvent event, int buttonMask) {
        int stateMask = event.stateMask;
        return (stateMask & buttonMask) == buttonMask;
    }

    private static boolean isPressed(MouseEvent event, MouseButton button) {
        return OffScreenRenderWidget.mouseButton(event) == button;
    }

    private void dispatchMouseMoved(MouseEvent event) {
        this.browserWidget().dispatch(MouseMoved.newBuilder((com.teamdev.jxbrowser.ui.Point)this.localPoint(event)).locationOnScreen(this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(this.keyModifiers(event)).build());
    }

    private static MouseButton mouseButton(MouseEvent event) {
        if (event.button == SwtMouseButton.FIRST.value()) {
            return MouseButton.PRIMARY;
        }
        if (event.button == SwtMouseButton.SECOND.value()) {
            return MouseButton.MIDDLE;
        }
        if (event.button == SwtMouseButton.THIRD.value()) {
            return MouseButton.SECONDARY;
        }
        return MouseButton.MOUSE_BUTTON_UNSPECIFIED;
    }

    private com.teamdev.jxbrowser.ui.Point localPoint(MouseEvent event) {
        return Geometry.newPoint((double)event.x, (double)event.y);
    }

    private com.teamdev.jxbrowser.ui.Point screenPoint(MouseEvent event) {
        Point location = OffScreenRenderWidget.locationOnScreenSafe((Composite)event.widget);
        int globalX = location.x + event.x;
        int globalY = location.y + event.y;
        return Geometry.newPoint((double)globalX, (double)globalY);
    }

    private static Point locationOnScreenSafe(Composite composite) {
        return composite.isVisible() ? composite.toDisplay(0, 0) : new Point(0, 0);
    }

    private void requestFocusIfNecessary() {
        if (!this.isFocusControl()) {
            this.setFocus();
        }
    }

    private void handleCompositionChanged(Event event) {
        if (this.ime.getCommitCount() > 0) {
            this.browserWidget().ime().commitText(event.text);
            this.isComposingImeText = false;
        } else {
            Rect caretRect = this.browserWidget().ime().getCaretPosition();
            this.getCaret().setLocation(caretRect.x(), caretRect.y() + caretRect.height());
            ArrayList<ImeTextSpan> imeTextSpans = new ArrayList<ImeTextSpan>();
            imeTextSpans.add(Ime.createTextSpan((int)0, (int)event.text.length(), (boolean)true));
            this.browserWidget().ime().setComposition(event.text, imeTextSpans);
            this.isComposingImeText = true;
        }
        event.doit = false;
    }

    private class FocusListener
    extends FocusAdapter {
        private final FocusCauseTracker focusCauseTracker;

        FocusListener(FocusCauseTracker focusCauseTracker) {
            this.focusCauseTracker = focusCauseTracker;
        }

        public void focusGained(FocusEvent e) {
            OffScreenRenderWidget.this.browserWidget().focus(this.focusCauseTracker.getFocusCause());
        }

        public void focusLost(FocusEvent e) {
            OffScreenRenderWidget.this.browserWidget().unfocus();
        }
    }

    private class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }
    }

    final class KeyListener
    extends KeyAdapter {
        KeyListener() {
        }

        private void notifyKeyTyped(KeyPressed keyPressed, char keyChar) {
            OffScreenRenderWidget.this.browserWidget().dispatch(KeyTyped.newBuilder((KeyCode)keyPressed.keyCode()).keyModifiers(keyPressed.keyModifiers()).keyLocation(keyPressed.keyLocation()).keyChar(keyChar).build());
        }

        public void keyPressed(KeyEvent e) {
            this.suppressTraversalKey(e);
            KeyCode keyCode = OffScreenRenderWidget.this.keyCodes.toKeyCode((ToolkitKey)SwtKey.from(e));
            char character = e.character;
            KeyModifiers modifiers = OffScreenRenderWidget.this.keyModifiers(e);
            if (Environment.isMac() && KeyEvents.isMacAccessKey((KeyCode)keyCode, (KeyModifiers)modifiers)) {
                character = KeyCodes.toAlphabeticChar((KeyCode)keyCode);
            }
            KeyPressed keyPressed = KeyPressed.newBuilder((KeyCode)keyCode).keyModifiers(modifiers).keyLocation(OffScreenRenderWidget.this.keyLocation(e)).build();
            OffScreenRenderWidget.this.browserWidget().dispatch(keyPressed);
            this.notifyKeyTyped(keyPressed, character);
        }

        private void suppressTraversalKey(KeyEvent event) {
            if (event.keyCode == 9) {
                event.doit = false;
            }
        }

        public void keyReleased(KeyEvent e) {
            KeyCode keyCode = OffScreenRenderWidget.this.keyCodes.toKeyCode((ToolkitKey)SwtKey.from(e));
            OffScreenRenderWidget.this.browserWidget().dispatch(KeyReleased.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.this.keyModifiers(e)).keyLocation(OffScreenRenderWidget.this.keyLocation(e)).build());
        }
    }

    final class MouseWheelListener
    implements org.eclipse.swt.events.MouseWheelListener {
        MouseWheelListener() {
        }

        public void mouseScrolled(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            ScrollType scrollType = ScrollType.SCROLL_TYPE_UNSPECIFIED;
            if ((event.widget.getStyle() & 1) != 0) {
                scrollType = ScrollType.UNIT_SCROLL;
            } else if ((event.widget.getStyle() & 2) != 0) {
                scrollType = ScrollType.BLOCK_SCROLL;
            }
            float pointsPerUnit = Environment.isMac() ? 10.0f : 33.333332f;
            float delta = (float)event.count * pointsPerUnit;
            float deltaX = OffScreenRenderWidget.this.isShiftDown(event) ? delta : 0.0f;
            float deltaY = !OffScreenRenderWidget.this.isShiftDown(event) ? delta : 0.0f;
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseWheel.newBuilder((com.teamdev.jxbrowser.ui.Point)OffScreenRenderWidget.this.localPoint(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).deltaX(deltaX).deltaY(deltaY).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).scrollType(scrollType).build());
        }
    }

    final class MouseMotionListener
    implements MouseMoveListener {
        MouseMotionListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            if ((e.stateMask & SWT.BUTTON_MASK) == 0) {
                OffScreenRenderWidget.this.dispatchMouseMoved(e);
            } else {
                OffScreenRenderWidget.this.dispatchMouseDragged(e);
            }
        }
    }

    final class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        public void mouseDown(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            if (OffScreenRenderWidget.this.isComposingImeText) {
                OffScreenRenderWidget.this.endImeComposition();
                return;
            }
            OffScreenRenderWidget.this.requestFocusIfNecessary();
            OffScreenRenderWidget.this.browserWidget().dispatch(MousePressed.newBuilder((com.teamdev.jxbrowser.ui.Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).clickCount(event.count).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }

        public void mouseUp(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseReleased.newBuilder((com.teamdev.jxbrowser.ui.Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }
    }

    final class MouseTrackListener
    extends MouseTrackAdapter {
        MouseTrackListener() {
        }

        public void mouseEnter(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseEntered.newBuilder((com.teamdev.jxbrowser.ui.Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }

        public void mouseExit(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseExited.newBuilder((com.teamdev.jxbrowser.ui.Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }
    }
}

