/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.menu;

import com.teamdev.jxbrowser.browser.callback.internal.ShowSuggestionsCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.Suggestion;
import com.teamdev.jxbrowser.suggestions.SuggestionsPopupType;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class SuggestionsPopup {
    private static final Map<BrowserId, SuggestionsPopup> OPEN_POPUPS = new ConcurrentHashMap<BrowserId, SuggestionsPopup>();
    private final ShowSuggestionsCallback.Params params;
    private final ShowSuggestionsCallback.Action action;
    private final BrowserId browserId;
    private final BrowserView parentBrowserView;
    private Shell parentShell;
    private Shell suggestionsShell;
    private Menu suggestionsMenu;

    public static Optional<SuggestionsPopup> fromBrowser(BrowserId id) {
        return Optional.ofNullable(OPEN_POPUPS.get(id));
    }

    public SuggestionsPopup(BrowserView parent, ShowSuggestionsCallback.Params params, ShowSuggestionsCallback.Action action) {
        this.parentBrowserView = parent;
        this.params = params;
        this.action = action;
        this.browserId = ((BrowserImpl)parent.getBrowser()).id();
        SuggestionsPopup.fromBrowser(this.browserId).ifPresent(SuggestionsPopup::hide);
    }

    private void fillSuggestions(List<Suggestion> suggestions) {
        for (Suggestion suggestion : suggestions) {
            MenuItem suggestionItem = new MenuItem(this.suggestionsMenu, 0);
            String text = this.params.popupType() == SuggestionsPopupType.PASSWORDS ? String.format("%s  %s", suggestion.getValue(), suggestion.getHiddenPassword()) : (this.params.popupType() == SuggestionsPopupType.ADDRESSES ? String.format("%s  %s", suggestion.getValue(), suggestion.getAddressOrFullname()) : (this.params.popupType() == SuggestionsPopupType.CREDIT_CARDS ? String.format("%s  %s", suggestion.getValue(), suggestion.getCreditCardInfo()) : suggestion.getValue()));
            suggestionItem.setText(text);
            suggestionItem.addListener(13, event -> this.action.accept(suggestion));
        }
    }

    private void clearSuggestions() {
        for (MenuItem item : this.suggestionsMenu.getItems()) {
            item.dispose();
        }
    }

    public void show() {
        SafeExecutor.asyncExec((Widget)this.parentBrowserView, () -> {
            this.parentShell = this.parentBrowserView.getShell();
            this.suggestionsShell = new Shell(this.parentShell, 1);
            this.suggestionsMenu = new Menu((Decorations)this.suggestionsShell, 8);
            org.eclipse.swt.graphics.Point parentLocation = this.parentBrowserView.toDisplay(0, 0);
            com.teamdev.jxbrowser.ui.internal.rpc.Point locationInBrowser = this.params.location();
            Point screenSpaceLocation = Point.of((int)(parentLocation.x + locationInBrowser.x()), (int)(parentLocation.y + locationInBrowser.y()));
            this.suggestionsShell.setLocation(screenSpaceLocation.x(), screenSpaceLocation.y());
            this.suggestionsShell.setLayout((Layout)new FillLayout());
            this.suggestionsMenu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent menuEvent) {
                    SafeExecutor.asyncExec((Widget)SuggestionsPopup.this.parentBrowserView, () -> {
                        if (!SuggestionsPopup.this.action.isClosed()) {
                            SuggestionsPopup.this.action.cancel();
                        }
                        OPEN_POPUPS.remove(SuggestionsPopup.this.browserId);
                    });
                }
            });
            this.fillSuggestions(this.params.suggestions());
            this.suggestionsMenu.setVisible(true);
            this.suggestionsMenu.setLocation(parentLocation.x + locationInBrowser.x(), parentLocation.y + locationInBrowser.y());
            this.suggestionsShell.pack();
            this.suggestionsShell.setVisible(true);
            OPEN_POPUPS.put(this.browserId, this);
        });
    }

    void updateSuggestions(List<Suggestion> updatedSuggestions) {
        SafeExecutor.asyncExec((Widget)this.parentBrowserView, () -> {
            this.clearSuggestions();
            this.fillSuggestions(updatedSuggestions);
            this.suggestionsShell.pack();
        });
    }

    void hide() {
        SafeExecutor.asyncExec((Widget)this.parentBrowserView, this::disposePopup);
    }

    private void disposePopup() {
        if (!this.suggestionsShell.isDisposed()) {
            this.suggestionsShell.dispose();
        }
    }
}

