/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.BrowserSettings;
import com.teamdev.jxbrowser.browser.DisplayMode;
import com.teamdev.jxbrowser.browser.UnsupportedRenderingModeException;
import com.teamdev.jxbrowser.browser.WebRtcIpHandlingPolicy;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.rpc.BoolSetting;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserSettingsStub;
import com.teamdev.jxbrowser.browser.internal.rpc.ColorSetting;
import com.teamdev.jxbrowser.browser.internal.rpc.DefaultFontSizeSetting;
import com.teamdev.jxbrowser.browser.internal.rpc.DisplayModeSetting;
import com.teamdev.jxbrowser.browser.internal.rpc.DisplayModeValue;
import com.teamdev.jxbrowser.browser.internal.rpc.StringSetting;
import com.teamdev.jxbrowser.browser.internal.rpc.WebRtcIpHandlingPolicySetting;
import com.teamdev.jxbrowser.browser.internal.rpc.WebRtcIpHandlingPolicyValue;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Color;
import com.teamdev.jxbrowser.ui.FontSizeInPixels;
import com.teamdev.jxbrowser.ui.internal.FontSizeTypes;

public final class BrowserSettingsImpl
extends CloseableImpl
implements BrowserSettings {
    private final BrowserImpl browser;
    private final ServiceConnectionImpl<BrowserSettingsStub> rpc;

    BrowserSettingsImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.rpc = new ServiceConnectionImpl<BrowserSettingsStub>(browser.id(), browser.engine().connection(), BrowserSettingsStub::new);
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public String defaultEncoding() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getDefaultEncoding, this.browser.id())).getValue();
    }

    @Override
    public void defaultEncoding(String defaultEncoding) {
        StringPreconditions.checkNotNullEmptyOrBlank(defaultEncoding);
        this.checkNotClosed();
        StringSetting request = StringSetting.newBuilder().setBrowserId(this.browser.id()).setValue(defaultEncoding).build();
        this.rpc.invoke(this.rpc.stub()::setDefaultEncoding, request);
    }

    @Override
    public Color defaultBackgroundColor() {
        this.checkNotClosed();
        return (Color)this.rpc.invoke(this.rpc.stub()::getDefaultBackgroundColor, this.browser.id());
    }

    @Override
    public void defaultBackgroundColor(Color color) {
        Preconditions.checkNotNull(color);
        this.checkNotClosed();
        ColorSetting request = ColorSetting.newBuilder().setBrowserId(this.browser.id()).setValue((com.teamdev.jxbrowser.ui.internal.rpc.Color)color).build();
        this.rpc.invoke(this.rpc.stub()::setDefaultBackgroundColor, request);
    }

    @Override
    public boolean isJavaScriptEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isJavaScriptEnabled, this.browser.id())).getValue();
    }

    private void setJavaScriptEnabled(boolean enabled) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enabled).build();
        this.rpc.invoke(this.rpc.stub()::setJavaScriptEnabled, request);
    }

    @Override
    public void enableJavaScript() {
        this.setJavaScriptEnabled(true);
    }

    @Override
    public void disableJavaScript() {
        this.setJavaScriptEnabled(false);
    }

    @Override
    public boolean isAllowLoadingImagesAutomatically() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAllowLoadingImagesAutomatically, this.browser.id())).getValue();
    }

    private void setAllowLoadingImagesAutomatically(boolean enabled) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enabled).build();
        this.rpc.invoke(this.rpc.stub()::setAllowLoadingImagesAutomatically, request);
    }

    @Override
    public void allowLoadingImagesAutomatically() {
        this.setAllowLoadingImagesAutomatically(true);
    }

    @Override
    public void disallowLoadingImagesAutomatically() {
        this.setAllowLoadingImagesAutomatically(false);
    }

    @Override
    public boolean isImagesEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isImagesEnabled, this.browser.id())).getValue();
    }

    private void setImagesEnabled(boolean enabled) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enabled).build();
        this.rpc.invoke(this.rpc.stub()::setImagesEnabled, request);
    }

    @Override
    public void enableImages() {
        this.setImagesEnabled(true);
    }

    @Override
    public void disableImages() {
        this.setImagesEnabled(false);
    }

    @Override
    public boolean isPluginsEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isPluginsEnabled, this.browser.id())).getValue();
    }

    private void setPluginsEnabled(boolean enabled) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enabled).build();
        this.rpc.invoke(this.rpc.stub()::setPluginsEnabled, request);
    }

    @Override
    public void enablePlugins() {
        this.setPluginsEnabled(true);
    }

    @Override
    public void disablePlugins() {
        this.setPluginsEnabled(false);
    }

    @Override
    public boolean isAllowScriptsToCloseWindows() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAllowScriptsToCloseWindows, this.browser.id())).getValue();
    }

    private void setAllowScriptsToCloseWindows(boolean allow) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(allow).build();
        this.rpc.invoke(this.rpc.stub()::setAllowScriptsToCloseWindows, request);
    }

    @Override
    public void allowScriptsToCloseWindows() {
        this.setAllowScriptsToCloseWindows(true);
    }

    @Override
    public void disallowScriptsToCloseWindows() {
        this.setAllowScriptsToCloseWindows(false);
    }

    @Override
    public boolean isAllowJavaScriptAccessClipboard() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAllowJavaScriptAccessClipboard, this.browser.id())).getValue();
    }

    private void setAllowJavaScriptAccessClipboard(boolean allow) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(allow).build();
        this.rpc.invoke(this.rpc.stub()::setAllowJavaScriptAccessClipboard, request);
    }

    @Override
    public void allowJavaScriptAccessClipboard() {
        this.setAllowJavaScriptAccessClipboard(true);
    }

    @Override
    public void disallowJavaScriptAccessClipboard() {
        this.setAllowJavaScriptAccessClipboard(false);
    }

    @Override
    public boolean isLocalStorageEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isLocalStorageEnabled, this.browser.id())).getValue();
    }

    private void setLocalStorageEnabled(boolean enabled) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enabled).build();
        this.rpc.invoke(this.rpc.stub()::setLocalStorageEnabled, request);
    }

    @Override
    public void enableLocalStorage() {
        this.setLocalStorageEnabled(true);
    }

    @Override
    public void disableLocalStorage() {
        this.setLocalStorageEnabled(false);
    }

    @Override
    public boolean isAllowRunningInsecureContent() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAllowRunningInsecureContent, this.browser.id())).getValue();
    }

    private void setAllowRunningInsecureContent(boolean allow) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(allow).build();
        this.rpc.invoke(this.rpc.stub()::setAllowRunningInsecureContent, request);
    }

    @Override
    public void allowRunningInsecureContent() {
        this.setAllowRunningInsecureContent(true);
    }

    @Override
    public void disallowRunningInsecureContent() {
        this.setAllowRunningInsecureContent(false);
    }

    @Override
    public WebRtcIpHandlingPolicy webRtcIpHandlingPolicy() {
        this.checkNotClosed();
        return ((WebRtcIpHandlingPolicyValue)this.rpc.invoke(this.rpc.stub()::getWebRtcIpHandlingPolicy, this.browser.id())).getValue();
    }

    @Override
    public void webRtcIpHandlingPolicy(WebRtcIpHandlingPolicy policy) {
        this.checkNotClosed();
        Preconditions.checkNotNull(policy);
        WebRtcIpHandlingPolicySetting request = WebRtcIpHandlingPolicySetting.newBuilder().setBrowserId(this.browser.id()).setValue(policy).build();
        this.rpc.invoke(this.rpc.stub()::setWebRtcIpHandlingPolicy, request);
    }

    @Override
    public void hideScrollbars() {
        this.setHideScrollbars(true);
    }

    @Override
    public void showScrollbars() {
        this.setHideScrollbars(false);
    }

    @Override
    public boolean scrollbarsHidden() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isHideScrollbars, this.browser.id())).getValue();
    }

    private void setHideScrollbars(boolean hide) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(hide).build();
        this.rpc.invoke(this.rpc.stub()::setHideScrollbars, request);
    }

    @Override
    public void allowJavaScriptAccessCookies() {
        this.setEnableCookies(true);
    }

    @Override
    public void disallowJavaScriptAccessCookies() {
        this.setEnableCookies(false);
    }

    @Override
    public boolean isAllowJavaScriptAccessCookies() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isCookieEnabled, this.browser.id())).getValue();
    }

    @Override
    public void enableTransparentBackground() {
        this.setTransparentBackgroundEnabled(true);
    }

    @Override
    public void disableTransparentBackground() {
        this.setTransparentBackgroundEnabled(false);
    }

    @Override
    public boolean isTransparentBackgroundEnabled() {
        this.checkNotClosed();
        this.checkRenderingMode();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isBackgroundTransparent, this.browser.id())).getValue();
    }

    private void setTransparentBackgroundEnabled(boolean transparent) {
        this.checkNotClosed();
        this.checkRenderingMode();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(transparent).build();
        this.rpc.invoke(this.rpc.stub()::setTransparentBackground, request);
    }

    private void checkRenderingMode() {
        RenderingMode renderingMode;
        if ((Environment.isWindows() || Environment.isLinux()) && (renderingMode = this.browser.engine().options().renderingMode()) == RenderingMode.HARDWARE_ACCELERATED) {
            throw new UnsupportedRenderingModeException(renderingMode);
        }
    }

    private void setEnableCookies(boolean enable) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enable).build();
        this.rpc.invoke(this.rpc.stub()::setCookieEnabled, request);
    }

    @Override
    public boolean isOverscrollHistoryNavigationEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isOverscrollHistoryNavigationEnabled, this.browser.id())).getValue();
    }

    private void setOverscrollHistoryNavigationEnabled(boolean enabled) {
        this.checkNotClosed();
        BoolSetting request = BoolSetting.newBuilder().setBrowserId(this.browser.id()).setValue(enabled).build();
        this.rpc.invoke(this.rpc.stub()::setOverscrollHistoryNavigationEnabled, request);
    }

    @Override
    public void enableOverscrollHistoryNavigation() {
        this.setOverscrollHistoryNavigationEnabled(true);
    }

    @Override
    public void disableOverscrollHistoryNavigation() {
        this.setOverscrollHistoryNavigationEnabled(false);
    }

    @Override
    public void defaultFontSize(FontSizeInPixels fontSize) {
        this.checkNotClosed();
        Preconditions.checkArgument(fontSize.value() >= 9, "Default font size must not be less than 9.");
        DefaultFontSizeSetting request = DefaultFontSizeSetting.newBuilder().setBrowserId(this.browser.id()).setValue(FontSizeTypes.cast(fontSize)).build();
        this.rpc.invoke(this.rpc.stub()::setDefaultFontSize, request);
    }

    @Override
    public FontSizeInPixels defaultFontSize() {
        this.checkNotClosed();
        return (FontSizeInPixels)this.rpc.invoke(this.rpc.stub()::getDefaultFontSize, this.browser.id());
    }

    @Override
    public DisplayMode displayMode() {
        this.checkNotClosed();
        return ((DisplayModeValue)this.rpc.invoke(this.rpc.stub()::getDisplayMode, this.browser.id())).getValue();
    }

    @Override
    public void displayMode(DisplayMode displayMode) {
        this.checkNotClosed();
        Preconditions.checkNotNull(displayMode);
        DisplayModeSetting request = DisplayModeSetting.newBuilder().setBrowserId(this.browser.id()).setValue(displayMode).build();
        this.rpc.invoke(this.rpc.stub()::setDisplayMode, request);
    }
}

