/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.BinariesDelivery;
import com.teamdev.jxbrowser.engine.ChromiumBinariesDeliveryException;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.engine.internal.FileLock;
import com.teamdev.jxbrowser.internal.BinariesIntegrity;
import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.OfficialDelivery;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public final class ChromiumBinaries {
    private static final String LOCK_FILE_NAME = "extraction.lock";

    public static void deliverToDefaultDirectory() {
        ChromiumBinaries.deliverTo(Environment.defaultChromiumDir());
    }

    public static void deliverToDefaultDirectory(BinariesDelivery delivery) {
        ChromiumBinaries.deliverTo(Environment.defaultChromiumDir(), delivery);
    }

    public static void deliverTo(Path chromiumDir) {
        Preconditions.checkNotNull(chromiumDir);
        ChromiumBinaries.deliverTo(chromiumDir, new OfficialDelivery());
    }

    public static void deliverTo(Path chromiumDir, BinariesDelivery delivery) {
        boolean verifyBinaries;
        Preconditions.checkNotNull(chromiumDir);
        Preconditions.checkNotNull(delivery);
        boolean bl = verifyBinaries = !SystemProperties.hasProperty("jxbrowser.chromium.verification.off");
        if (!verifyBinaries && delivery instanceof OfficialDelivery) {
            Logger.debug("Skip verifying and extracting the binaries, because it's explicitly disabled.");
            return;
        }
        List<BinariesListing> listings = BinariesListing.forCurrentPlatform();
        if (listings.isEmpty()) {
            Logger.debug("Skip the binaries delivery, because no listings were found.");
            return;
        }
        ChromiumBinaries.createIfNecessary(chromiumDir);
        BinariesIntegrity integrity = new BinariesIntegrity(listings, chromiumDir);
        ChromiumBinaries.trySynchronized(chromiumDir, () -> {
            if (verifyBinaries && integrity.verify()) {
                return;
            }
            try {
                delivery.deliverTo(chromiumDir);
            }
            catch (ChromiumBinariesDeliveryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ChromiumBinariesDeliveryException(e);
            }
            if (verifyBinaries) {
                integrity.verifyOrThrow();
            }
        }, () -> {
            Logger.debug("The directory '{0}' is not writable", chromiumDir);
            if (verifyBinaries) {
                Logger.debug("Checking what is inside.");
                integrity.verifyOrThrow();
            }
        });
    }

    private ChromiumBinaries() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trySynchronized(Path lockDirectory, Runnable syncAction, Runnable notSyncAction) {
        Class<EngineImpl> clazz = EngineImpl.class;
        synchronized (EngineImpl.class) {
            Logger.debug("Acquiring an exclusive lock...");
            try (FileLock ignored = new FileLock(lockDirectory, LOCK_FILE_NAME);){
                syncAction.run();
            }
            catch (AccessDeniedException e) {
                Logger.debug("Acquiring an exclusive lock... Access denied. [FAIL]");
                notSyncAction.run();
            }
            catch (IOException e) {
                Logger.error("Acquiring an exclusive lock... [FAIL]");
                throw new ChromiumBinariesDeliveryException("Acquiring an exclusive lock... [FAIL]", e);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void createIfNecessary(Path directory) {
        if (Files.exists(directory, new LinkOption[0])) {
            return;
        }
        Logger.debug("Creating directory: {0}", directory);
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.error("Creating directory [FAIL]");
            throw new ChromiumBinariesDeliveryException("Failed to create a directory", e);
        }
    }
}

