/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class LinuxDynamicLibraries {
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final List<String> libraries = ImmutableList.of("libudev.so.0", "libgcrypt.so.11", "libcrypto.so.1.0.0");
    private static final String SO_EXTENSION = "so.";
    private static final String HMAC_EXTENSION = "hmac";

    private LinuxDynamicLibraries() {
    }

    public static void addToLibraryPath(ProcessBuilder processBuilder, Path directoryPath) {
        Map<String, String> environment = processBuilder.environment();
        String newValue = directoryPath.toString();
        if (environment.containsKey(LD_LIBRARY_PATH)) {
            newValue = newValue + ':' + environment.get(LD_LIBRARY_PATH);
        }
        environment.put(LD_LIBRARY_PATH, newValue);
    }

    public static void createSymlinks(Path targetDirectory) {
        for (String library : libraries) {
            Path expectedPath = LinuxDynamicLibraries.getExpectedLibraryPath();
            Path expectedLibraryPath = expectedPath.resolve(library);
            if (Files.exists(expectedLibraryPath, new LinkOption[0])) {
                Logger.debug("{0}... exists in the {1} default location", library, expectedPath);
                continue;
            }
            int indexBeforeVersion = library.lastIndexOf(SO_EXTENSION) + SO_EXTENSION.length();
            String pattern = library.substring(0, indexBeforeVersion + 1);
            Optional<Path> libraryPath = LinuxDynamicLibraries.findLibrary(pattern);
            if (!libraryPath.isPresent()) {
                Logger.warn("Failed to find {0}x.x.x", pattern);
                continue;
            }
            Path absolutePath = libraryPath.get();
            LinuxDynamicLibraries.createSymlink(library, targetDirectory, absolutePath);
            Path parentDirectory = absolutePath.getParent();
            String actualLibraryName = absolutePath.getFileName().toString();
            LinuxDynamicLibraries.createHmacSymLink(actualLibraryName, targetDirectory, parentDirectory);
        }
    }

    private static void createHmacSymLink(String libraryName, Path targetDirectory, Path libraryPath) {
        Logger.debug("Searching for the {0} hmac file", libraryName);
        String hmacName = String.format("%s.%s", libraryName, HMAC_EXTENSION);
        Optional<Path> hmacFilePath = com.teamdev.jxbrowser.internal.Files.findFileWithSuffix(libraryPath, hmacName);
        if (hmacFilePath.isPresent()) {
            Logger.debug("Found {0}", hmacFilePath.get());
            LinuxDynamicLibraries.createSymlink(hmacName, targetDirectory, hmacFilePath.get());
        }
    }

    private static void createSymlink(String symlinkName, Path targetDir, Path targetFile) {
        Path symlink = targetDir.resolve(symlinkName);
        if (Files.exists(symlink, new LinkOption[0]) && LinuxDynamicLibraries.targetExists(symlink)) {
            Logger.debug("{0}... symlink and its target exist", symlink);
            return;
        }
        try {
            Logger.debug("Creating symlink: {0}", symlink);
            Files.createSymbolicLink(symlink, targetFile, new FileAttribute[0]);
        }
        catch (FileNotFoundException e) {
            Logger.error("Creating symlink: {0} [FAIL]. File already exists.", symlink);
        }
        catch (IOException e) {
            Logger.error("Creating symlink: {0} [FAIL]: {1}", symlink, e.getMessage());
        }
    }

    private static Optional<Path> findLibrary(String prefix) {
        List<Path> possibleLocations = LinuxDynamicLibraries.possibleLibraryLocations();
        for (Path libraryPath : possibleLocations) {
            Logger.debug("Looking for {0} x.x.x in {1} library path ...", prefix, libraryPath);
            Optional<Path> library = com.teamdev.jxbrowser.internal.Files.findFileWithPrefix(libraryPath, prefix);
            if (!library.isPresent()) continue;
            return library;
        }
        return Optional.empty();
    }

    private static boolean targetExists(Path link) {
        try {
            Path linkTarget = Files.readSymbolicLink(link);
            return Files.exists(linkTarget, new LinkOption[0]);
        }
        catch (IOException e) {
            Logger.error("Couldn't check the target of {0}", (Throwable)e, link);
            return false;
        }
    }

    private static List<Path> possibleLibraryLocations() {
        ImmutableList.Builder<String> paths = ImmutableList.builder();
        if (Environment.isArm()) {
            paths.add((E[])new String[]{"/lib/aarch64-linux-gnu/", "/lib/", "/usr/lib/"});
        } else {
            paths.add((E[])new String[]{"/lib/x86_64-linux-gnu/", "/lib64/", "/usr/lib64/"});
        }
        return paths.build().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
    }

    private static Path getExpectedLibraryPath() {
        if (Environment.is64Bit()) {
            if (Environment.isArm()) {
                return Paths.get("/lib/aarch64-linux-gnu/", new String[0]);
            }
            return Paths.get("/lib/x86_64-linux-gnu/", new String[0]);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }
}

