/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.engine.ChromiumBinariesDeliveryException;
import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.ChromiumFile;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Path;
import java.util.List;

public final class BinariesIntegrity {
    private final Path chromiumDir;
    private final List<BinariesListing> listings;

    public BinariesIntegrity(List<BinariesListing> listings, Path chromiumDir) {
        this.listings = ImmutableList.copyOf(listings);
        this.chromiumDir = chromiumDir;
    }

    public void verifyOrThrow() {
        if (!this.verify()) {
            throw new ChromiumBinariesDeliveryException("Failed to check integrity of the Chromium binaries.");
        }
    }

    public boolean verify() {
        if (SystemProperties.hasProperty("jxbrowser.chromium.verification.off")) {
            Logger.debug("Skip checking binaries integrity, because it is explicitly disabled.");
            return true;
        }
        Logger.debug("Checking binaries integrity in {0}...", this.chromiumDir);
        for (BinariesListing listing : this.listings) {
            if (!this.verify(listing)) continue;
            Logger.debug("Checking binaries integrity... [OK]");
            return true;
        }
        Logger.debug("Checking binaries integrity... [FAIL]");
        return false;
    }

    private boolean verify(BinariesListing listing) {
        Logger.debug("Using {0} listing...", listing.name());
        List<ChromiumFile> files = listing.files();
        for (ChromiumFile chromiumFile : files) {
            if (chromiumFile.checkIntegrity(this.chromiumDir)) continue;
            return false;
        }
        return true;
    }
}

