/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class ChromiumFile {
    private final long expectedSize;
    private final String relativePath;

    ChromiumFile(String relativePath, long expectedSize) {
        this.expectedSize = expectedSize;
        this.relativePath = relativePath;
    }

    boolean checkIntegrity(Path baseDirectory) {
        Path file = this.absolutePath(baseDirectory);
        if (!Files.exists(file, new LinkOption[0])) {
            Logger.debug("Checked {0}: File does not exist", file);
            return false;
        }
        long actualSize = file.toFile().length();
        if (this.expectedSize != actualSize) {
            Logger.debug("Checked {0}: Expected {1} bytes, but got: {2} bytes.", file, this.expectedSize, actualSize);
            return false;
        }
        Logger.debug("Checked {0}.", file);
        return true;
    }

    public Path absolutePath(Path chromiumDir) {
        return chromiumDir.resolve(this.relativePath);
    }
}

