/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.engine.ChromiumProcessStartupFailureException;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.internal.AcceleratedLightweight;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.ChromiumProcessException;
import com.teamdev.jxbrowser.internal.ChromiumProcessLinux;
import com.teamdev.jxbrowser.internal.ChromiumProcessLogger;
import com.teamdev.jxbrowser.internal.ChromiumProcessMac;
import com.teamdev.jxbrowser.internal.ChromiumProcessWin;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessEvent;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessStartFailed;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessTerminated;
import com.teamdev.jxbrowser.internal.platform.win.OsCompatibilityMode;
import com.teamdev.jxbrowser.internal.rpc.ProprietaryFeature;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.os.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class ChromiumProcess
extends CloseableImpl
implements Observable<ChromiumProcessEvent> {
    private static final String GOOGLE_API_KEY = "GOOGLE_API_KEY";
    private static final String GOOGLE_DEFAULT_CLIENT_ID = "GOOGLE_DEFAULT_CLIENT_ID";
    private static final String GOOGLE_DEFAULT_CLIENT_SECRET = "GOOGLE_DEFAULT_CLIENT_SECRET";
    private static final String AUTOPLAY_POLICY_NO_USER_GESTURE_REQUIRED = "no-user-gesture-required";
    private final int port;
    private final Path processFile;
    private final Path workingDir;
    private final ObservableHelper<ChromiumProcessEvent> observable;
    private final ExecutorService chromiumProcessService;
    private Process process;
    private int exitCode;
    private String crashDumpDirPath;

    public static ChromiumProcess create(int port, Path chromiumDir) {
        if (Environment.isWindows()) {
            return new ChromiumProcessWin(port, chromiumDir);
        }
        if (Environment.isMac()) {
            return new ChromiumProcessMac(port, chromiumDir);
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            return new ChromiumProcessLinux(port, chromiumDir);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    ChromiumProcess(int port, Path chromiumDir, String executableName) {
        this.port = port;
        this.workingDir = chromiumDir;
        this.processFile = chromiumDir.resolve(executableName);
        if (!java.nio.file.Files.exists(this.processFile, new LinkOption[0])) {
            throw ChromiumProcess.invalidDirectoryException(chromiumDir);
        }
        this.observable = new ObservableHelper();
        this.chromiumProcessService = Executors.newFixedThreadPool(1, runnable -> {
            Thread chromiumProcessThread = new Thread(runnable);
            chromiumProcessThread.setName("Chromium Process Thread");
            return chromiumProcessThread;
        });
    }

    private static IllegalStateException invalidDirectoryException(Path chromiumDir) {
        return new IllegalStateException(String.format("The %s directory doesn't include the required Chromium binaries.", chromiumDir));
    }

    public void terminate() {
        if (!this.isStarted()) {
            return;
        }
        this.process.destroyForcibly();
        this.close();
    }

    @Override
    public void close() {
        while (!this.chromiumProcessService.isTerminated()) {
            try {
                this.chromiumProcessService.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                Logger.debug("Awaiting process termination: the current thread has been interrupted.");
            }
        }
        super.close();
    }

    Path workingDir() {
        return this.workingDir;
    }

    Path processFile() {
        return this.processFile;
    }

    @Override
    public <E extends ChromiumProcessEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.observable.on(eventClass, observer);
    }

    protected abstract Optional<String> defaultCrashDumpDir();

    protected abstract Collection<String> platformCommandLineArgs(EngineOptions var1);

    private Collection<String> commandLineArgs(EngineOptions engineOptions) {
        Map<Scheme, InterceptUrlRequestCallback> schemes;
        boolean headlessOffScreen;
        ChromiumSwitches switches = new ChromiumSwitches();
        Preconditions.checkArgument(this.port != 0);
        switches.add("port", this.port);
        ToolkitLibrary toolkitLibrary = ToolkitLibrary.instance();
        switches.add("pid", toolkitLibrary.getCurrentProcessId());
        switches.add("browsercore");
        switches.add("no-default-browser-check");
        boolean offScreenRenderingMode = engineOptions.renderingMode().equals((Object)RenderingMode.OFF_SCREEN);
        if (offScreenRenderingMode) {
            switches.add("off-screen");
        }
        engineOptions.userAgent().ifPresent(userAgent -> switches.add("user-agent", userAgent));
        Language language = engineOptions.language();
        switches.add("lang", (Object)language);
        engineOptions.remoteDebuggingPort().ifPresent(port -> switches.add("remote-debugging-port", port));
        switches.add("hung-render-delay-seconds", engineOptions.rendererHangTimeout().getSeconds());
        engineOptions.diskCacheSize().ifPresent(diskCacheSize -> switches.add("disk-cache-size", diskCacheSize));
        if (engineOptions.isIncognitoEnabled()) {
            switches.add("incognito");
        }
        if (engineOptions.isDnsQuickCheckDisabled()) {
            switches.add("disable-dns-quick-check");
        }
        if (engineOptions.isTouchMenuDisabled()) {
            switches.add("disable-touch-menu");
        }
        if (engineOptions.isSandboxDisabled()) {
            switches.add("no-sandbox");
        }
        if (engineOptions.isWebSecurityDisabled()) {
            switches.add("disable-web-security");
        }
        if (engineOptions.isFileAccessFromFilesAllowed()) {
            switches.add("allow-file-access-from-files");
        }
        if (engineOptions.isAutoplayEnabled()) {
            switches.add("autoplay-policy", AUTOPLAY_POLICY_NO_USER_GESTURE_REQUIRED);
        }
        if (engineOptions.isGpuDisabled()) {
            switches.add("disable-gpu");
        }
        if (!engineOptions.secureOriginWhiteList().isEmpty()) {
            switches.add("unsafely-treat-insecure-origin-as-secure", String.join((CharSequence)",", engineOptions.secureOriginWhiteList()));
        }
        int features = 0;
        for (ProprietaryFeature feature : ChromiumProcess.supportedFeatures(engineOptions.proprietaryFeatures())) {
            features |= feature.getNumber();
        }
        switches.add("proprietary-features", features);
        if (Logger.isTraceEnabled()) {
            switches.add("vmodule=*/browsercore/*=1");
        }
        engineOptions.passwordStore().ifPresent(passwordStore -> switches.add("password-store", passwordStore.value()));
        switches.add("user-data-dir", engineOptions.userDataDir().toAbsolutePath());
        switches.addAll(this.platformCommandLineArgs(engineOptions));
        this.defaultCrashDumpDir().ifPresent(dir -> {
            String path = SystemProperties.get("jxbrowser.crash.dump.dir", dir);
            if (path != null && !path.isEmpty()) {
                File crashDumpDir = new File(path);
                String absolutePath = crashDumpDir.getAbsolutePath();
                this.crashDumpDirPath = crashDumpDir.getAbsolutePath();
                try {
                    Files.validateDirectory(crashDumpDir);
                    switches.add("crash-dump-dir", absolutePath);
                }
                catch (IOException e) {
                    Logger.warn("Failed to create/access crash dump directory at {0}: {1}", absolutePath, e.getMessage());
                }
            }
        });
        if (engineOptions.isChromiumTrafficDisabled()) {
            switches.add("disable-background-networking");
            switches.add("disable-sync");
            if (engineOptions.proprietaryFeatures().isEmpty()) {
                switches.add("disable-component-update");
            }
        }
        boolean bl = headlessOffScreen = HeadlessToolkits.isHeadlessToolkit() && offScreenRenderingMode;
        if (headlessOffScreen) {
            switches.add("enable-custom-dropdowns");
        }
        if (Boolean.getBoolean("jxbrowser.use.native.keyboard.input") && !headlessOffScreen) {
            switches.add("use-client-native-keyboard-input");
        }
        if (Boolean.getBoolean("jxbrowser.linux.touch.screen")) {
            switches.add("touch-environment");
        }
        if (!(schemes = engineOptions.schemes()).isEmpty()) {
            StringBuilder builder = new StringBuilder();
            schemes.keySet().forEach(scheme -> builder.append(scheme.name()).append(","));
            switches.add("schemes", builder.toString());
        }
        switches.addAll(engineOptions.switches());
        if (engineOptions.isMediaRoutingEnabled()) {
            Optional<String> optionalFeaturesSwitch = switches.toList().stream().filter(chromiumSwitch -> chromiumSwitch.startsWith(ChromiumSwitches.SWITCH_PREFIX + "enable-features")).findFirst();
            if (optionalFeaturesSwitch.isPresent()) {
                String featuresSwitch = optionalFeaturesSwitch.get();
                if (!featuresSwitch.contains("MediaRouter")) {
                    String switchWithMediaRouting = featuresSwitch.concat(",MediaRouter");
                    switches.replaceAll(featuresSwitch, switchWithMediaRouting);
                }
            } else {
                switches.add(String.format("%s=%s", "enable-features", "MediaRouter"));
            }
        }
        List<String> args = switches.toList();
        AcceleratedLightweight acceleratedLightweight = new AcceleratedLightweight();
        acceleratedLightweight.ensureDisabled(args);
        return args;
    }

    private static ImmutableSet<ProprietaryFeature> supportedFeatures(Set<com.teamdev.jxbrowser.engine.ProprietaryFeature> features) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        features.forEach(feature -> {
            if (feature == com.teamdev.jxbrowser.engine.ProprietaryFeature.AAC) {
                result.add(ProprietaryFeature.AAC);
            }
            if (feature == com.teamdev.jxbrowser.engine.ProprietaryFeature.H_264) {
                result.add(ProprietaryFeature.H_264);
            }
            if (feature == com.teamdev.jxbrowser.engine.ProprietaryFeature.WIDEVINE) {
                result.add(ProprietaryFeature.WIDEVINE);
            }
            if (feature == com.teamdev.jxbrowser.engine.ProprietaryFeature.HEVC) {
                result.add(ProprietaryFeature.HEVC);
            }
        });
        return result.build();
    }

    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
    }

    public void start(EngineOptions engineOptions) {
        if (this.isStarted()) {
            return;
        }
        this.startInternal(engineOptions);
    }

    private void startInternal(EngineOptions engineOptions) {
        Future<?> task = this.chromiumProcessService.submit(() -> {
            try {
                Collection<String> args = this.commandLineArgs(engineOptions);
                Logger.debug("Starting chromium process...");
                ArrayList<String> command = new ArrayList<String>();
                command.add(this.processFile.toAbsolutePath().toString());
                command.addAll(args);
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                processBuilder.directory(this.workingDir.toFile());
                processBuilder.redirectErrorStream(true);
                if (Environment.isWindows()) {
                    OsCompatibilityMode.removeIfExists(processBuilder);
                }
                this.configGoogleApiKeys(engineOptions, processBuilder);
                this.preProcessRun(processBuilder, engineOptions);
                StringBuilder commandLine = new StringBuilder();
                for (String commandItem : command) {
                    commandLine.append(commandItem);
                    commandLine.append(' ');
                }
                Logger.debug(commandLine.toString());
                this.process = processBuilder.start();
                Logger.debug("Starting chromium process... [OK]");
            }
            catch (IOException e) {
                Logger.error("Starting chromium process... [FAILED]", e);
                this.observable.notifyObservers(new ChromiumProcessStartFailed());
                throw new ChromiumProcessException(e);
            }
        });
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ChromiumProcessStartupFailureException(e);
        }
        this.chromiumProcessService.execute(() -> {
            try {
                ChromiumProcessLogger processLogger = new ChromiumProcessLogger();
                processLogger.startLogging(this.process);
                this.exitCode = this.process.waitFor();
                Logger.debug("Chromium process exit code: {0}", this.exitCode);
                this.observable.notifyObservers(new ChromiumProcessTerminated(this.exitCode));
            }
            catch (InterruptedException ignore) {
                Logger.debug("The chromium process thread has been interrupted.");
            }
            finally {
                this.chromiumProcessService.shutdown();
            }
        });
    }

    private void configGoogleApiKeys(EngineOptions engineOptions, ProcessBuilder processBuilder) {
        engineOptions.googleApiKey().ifPresent(key -> processBuilder.environment().put(GOOGLE_API_KEY, (String)key));
        engineOptions.googleDefaultClientId().ifPresent(clientId -> processBuilder.environment().put(GOOGLE_DEFAULT_CLIENT_ID, (String)clientId));
        engineOptions.googleDefaultClientSecret().ifPresent(secret -> processBuilder.environment().put(GOOGLE_DEFAULT_CLIENT_SECRET, (String)secret));
    }

    public boolean isStarted() {
        return this.process != null && !this.isClosed();
    }

    public int exitCode() {
        return this.exitCode;
    }

    public Optional<String> crashDumpDir() {
        return Optional.ofNullable(this.crashDumpDirPath);
    }
}

