/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.net.Scheme;
import java.util.Arrays;

public enum NonInterceptableScheme {
    ABOUT("about"),
    BLOB("blob"),
    CONTENT("content"),
    CONTENT_ID("cid"),
    DATA("data"),
    FILE("file"),
    FILE_SYSTEM("filesystem"),
    FTP("ftp"),
    JAVA_SCRIPT("javascript"),
    MAIL_TO("mailto"),
    QUIC_TRANSPORT("quic-transport"),
    TEL("tel"),
    WS("ws"),
    WSS("wss"),
    CHROME_DEVTOOLS("devtools"),
    CHROME_UI("chrome"),
    CHROME_ERROR("chrome-error"),
    CHROME_DISTILLER("chrome-distiller"),
    CHROME_UI_UNTRUSTED("chrome-untrusted"),
    CHROME_GUEST("chrome-guest"),
    CHROME_SEARCH("chrome-search"),
    CHROME_EXTENSION("chrome-extension"),
    CHROME_NATIVE("chrome-native"),
    VIEW_SOURCE("view-source"),
    EXTERNAL_FILE("externalfile"),
    GOOGLE_CHROME("googlechrome");

    private final String name;

    public static boolean contains(Scheme scheme) {
        return Arrays.stream(NonInterceptableScheme.values()).anyMatch(value -> value.name.equalsIgnoreCase(scheme.name()));
    }

    public static String stringRepresentation() {
        return Arrays.asList(NonInterceptableScheme.values()).toString();
    }

    private NonInterceptableScheme(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

