/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.menu;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.menu.SpellCheckMenu;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.menu.ContextMenu;
import java.util.Iterator;
import javafx.collections.ObservableList;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public final class SpellingContextMenu
extends ContextMenu {
    public SpellingContextMenu(BrowserView parent, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        super(parent, params, callback);
    }

    @Override
    protected void initialize(javafx.scene.control.ContextMenu contextMenu) {
        new Customize(contextMenu).perform();
    }

    private final class Customize {
        private final Browser browser;
        private final SpellCheckMenu spellCheckMenu;
        private final ObservableList<MenuItem> menuItems;

        Customize(javafx.scene.control.ContextMenu contextMenu) {
            this.browser = SpellingContextMenu.this.params().browser();
            this.spellCheckMenu = SpellingContextMenu.this.params().spellCheckMenu();
            this.menuItems = contextMenu.getItems();
        }

        private void perform() {
            this.addSuggestions();
            this.offerAddingToDictionary();
        }

        private SpellCheckMenu menu() {
            return SpellingContextMenu.this.params().spellCheckMenu();
        }

        private void addSuggestions() {
            Iterator iterator = this.spellCheckMenu.dictionarySuggestions().iterator();
            while (iterator.hasNext()) {
                String suggestion = (String)iterator.next();
                this.addSuggestion(suggestion);
                boolean lastSuggestion = !iterator.hasNext();
                if (!lastSuggestion) continue;
                this.menuItems.add((Object)new SeparatorMenuItem());
            }
        }

        private void addSuggestion(String suggestion) {
            MenuItem menuItem = new MenuItem(suggestion);
            menuItem.setOnAction(event -> {
                this.browser.replaceMisspelledWord(suggestion);
                SpellingContextMenu.this.callback().close();
            });
            this.menuItems.add((Object)menuItem);
        }

        private void offerAddingToDictionary() {
            MenuItem menuItem = new MenuItem(this.spellCheckMenu.addToDictionaryMenuItemText());
            menuItem.setOnAction(event -> {
                Dictionary dictionary = this.browser.engine().spellChecker().customDictionary();
                dictionary.add(this.menu().misspelledWord());
                SpellingContextMenu.this.callback().close();
            });
            this.menuItems.add((Object)menuItem);
        }
    }
}

