/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Rect;
import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.Node;

final class InputMethodRequests
implements javafx.scene.input.InputMethodRequests {
    private final Node node;
    private final BrowserWidget widget;
    private final Supplier<Double> scaleFactor;

    InputMethodRequests(BrowserWidget widget, Supplier<Double> scaleFactor, Node node) {
        this.widget = widget;
        this.scaleFactor = scaleFactor;
        this.node = node;
    }

    public Point2D getTextLocation(int offset) {
        Rect caretRect = this.widget.ime().getCaretPosition();
        Point2D result = this.node.localToScreen(new Point2D((double)caretRect.x(), (double)(caretRect.y() + caretRect.height())));
        if (Environment.isWindows() && Environment.isJre8()) {
            result = result.multiply(this.scaleFactor.get().doubleValue());
        }
        return result;
    }

    public int getLocationOffset(int x, int y) {
        return 0;
    }

    public void cancelLatestCommittedText() {
    }

    public String getSelectedText() {
        return this.widget.ime().getSelectedText();
    }
}

