/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.MemoryId;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import java.nio.IntBuffer;
import java.util.Optional;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

final class MemoryImage {
    private IntBuffer buffer;
    private WritableImage image;
    private double deviceScaleFactor = 1.0;

    MemoryImage() {
        this.resetImage(Size.of((int)1, (int)1));
    }

    double getDeviceScaleFactor() {
        return this.deviceScaleFactor;
    }

    Optional<WritableImage> image() {
        return Optional.ofNullable(this.image);
    }

    private boolean validateImageSize(Size newSize) {
        return this.image.getWidth() == (double)newSize.width() && this.image.getHeight() == (double)newSize.height();
    }

    private void resetImage(Size size) {
        this.image = new WritableImage(size.width(), size.height());
        int[] pixels = new int[size.width() * size.height()];
        this.buffer = IntBuffer.wrap(pixels);
    }

    void updateImage(Size viewSize, Rect dirtyRect, MemoryId memoryId, double scaleFactor) {
        this.deviceScaleFactor = scaleFactor;
        if (this.image == null || !this.validateImageSize(viewSize)) {
            this.resetImage(viewSize);
        }
        int dirtyX = dirtyRect.origin().x();
        int dirtyY = dirtyRect.origin().y();
        int dirtyWidth = dirtyRect.size().width();
        int dirtyHeight = dirtyRect.size().height();
        ToolkitLibrary.instance().updatePixelInts(memoryId.getValue(), dirtyRect, viewSize, this.buffer.array());
        PixelWriter pixelWriter = this.image.getPixelWriter();
        int offset = viewSize.width() * dirtyY + dirtyX;
        pixelWriter.setPixels(dirtyX, dirtyY, dirtyWidth, dirtyHeight, (PixelFormat)PixelFormat.getIntArgbPreInstance(), this.buffer.array(), offset, viewSize.width());
    }

    void reset() {
        this.image = null;
    }
}

