/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.event.EventType;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

final class MouseBridge {
    private final InputMethods ime;
    private final BrowserWidget widget;
    private final Function<Point, Point> jfxPanelAdjustment;
    private final Function<Point, Point> pointScale;
    private final Map<EventType<? extends MouseEvent>, Consumer<MouseEvent>> mouseEventHandlers;

    MouseBridge(InputMethods ime, BrowserWidget widget, Function<Point, Point> jfxPanelAdjustment, Function<Point, Point> pointScale) {
        this.ime = ime;
        this.widget = widget;
        this.pointScale = pointScale;
        this.jfxPanelAdjustment = jfxPanelAdjustment;
        this.mouseEventHandlers = new HashMap<EventType<? extends MouseEvent>, Consumer<MouseEvent>>();
        this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_PRESSED, this::dispatchMousePressed);
        this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_RELEASED, this::dispatchMouseReleased);
        this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_ENTERED, this::dispatchMouseEntered);
        this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_EXITED, this::dispatchMouseExited);
        this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_MOVED, this::dispatchMouseMoved);
        this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_DRAGGED, this::dispatchMouseDragged);
    }

    void forward(MouseEvent event) {
        EventType eventType = event.getEventType();
        if (this.mouseEventHandlers.containsKey(eventType)) {
            this.mouseEventHandlers.get(eventType).accept(event);
        } else {
            Logger.debug((String)"Handler is not found for the event type: {0}", (Object[])new Object[]{eventType});
        }
    }

    private com.teamdev.jxbrowser.ui.MouseButton getMouseButton(MouseEvent event) {
        if (event.getButton() == MouseButton.NONE) {
            return com.teamdev.jxbrowser.ui.MouseButton.NO_BUTTON;
        }
        if (event.getButton() == MouseButton.PRIMARY) {
            return com.teamdev.jxbrowser.ui.MouseButton.PRIMARY;
        }
        if (event.getButton() == MouseButton.SECONDARY) {
            return com.teamdev.jxbrowser.ui.MouseButton.SECONDARY;
        }
        if (event.getButton() == MouseButton.MIDDLE) {
            return com.teamdev.jxbrowser.ui.MouseButton.MIDDLE;
        }
        return com.teamdev.jxbrowser.ui.MouseButton.MOUSE_BUTTON_UNSPECIFIED;
    }

    private Point getLocalPoint(MouseEvent event) {
        Point point = Point.of((int)((int)event.getX()), (int)((int)event.getY()));
        Point adjustedPoint = this.jfxPanelAdjustment.apply(point);
        return this.pointScale.apply(adjustedPoint);
    }

    private Point getScreenPoint(MouseEvent event) {
        Point point = Point.of((int)((int)event.getScreenX()), (int)((int)event.getScreenY()));
        return this.pointScale.apply(point);
    }

    private KeyModifiers getKeyModifiers(MouseEvent event) {
        return KeyModifiers.newBuilder().altDown(event.isAltDown()).shiftDown(event.isShiftDown()).controlDown(event.isControlDown()).metaDown(event.isMetaDown()).build();
    }

    private MouseModifiers getMouseModifiers(MouseEvent event) {
        return MouseModifiers.newBuilder().primaryButtonDown(event.isPrimaryButtonDown()).middleButtonDown(event.isMiddleButtonDown()).secondaryButtonDown(event.isSecondaryButtonDown()).build();
    }

    private void dispatchMouseEntered(MouseEvent event) {
        this.widget.dispatch(MouseEntered.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
    }

    private void dispatchMouseExited(MouseEvent event) {
        this.widget.dispatch(MouseExited.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
    }

    private void dispatchMouseMoved(MouseEvent event) {
        this.widget.dispatch(MouseMoved.newBuilder((Point)this.getLocalPoint(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
    }

    private void dispatchMousePressed(MouseEvent event) {
        if (this.ime.isComposingImeText()) {
            this.ime.cancelImeComposition(true);
            return;
        }
        this.widget.dispatch(MousePressed.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).clickCount(event.getClickCount()).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
    }

    private void dispatchMouseReleased(MouseEvent event) {
        this.widget.dispatch(MouseReleased.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).clickCount(event.getClickCount()).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
    }

    private void dispatchMouseDragged(MouseEvent event) {
        this.widget.dispatch(MouseDragged.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
    }
}

