/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.javafx.internal.dnd.DragAndDropBridge;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethods;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.MouseBridge;
import java.util.function.Function;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

final class MouseListener
implements EventHandler<MouseEvent> {
    private final DragAndDropBridge dnd;
    private final MouseBridge bridge;
    private Node node;

    static Builder newBuilder(BrowserWidget widget) {
        return new Builder(widget);
    }

    private MouseListener(BrowserWidget widget, InputMethods ime, DragAndDropBridge dnd, Function<Point, Point> jfxPanelAdjustment, Function<Point, Point> pointScale) {
        this.dnd = dnd;
        this.bridge = new MouseBridge(ime, widget, jfxPanelAdjustment, pointScale);
    }

    public void handle(MouseEvent event) {
        if (this.dnd.handleMouseEvent(event)) {
            return;
        }
        this.bridge.forward(event);
    }

    void attach(Node node) {
        this.node = node;
        this.node.addEventHandler(MouseEvent.ANY, (EventHandler)this);
    }

    void detach() {
        if (this.node != null) {
            this.node.removeEventHandler(MouseEvent.ANY, (EventHandler)this);
        }
        this.node = null;
    }

    static final class Builder {
        private final BrowserWidget widget;
        private InputMethods inputMethods;
        private DragAndDropBridge dnd;
        private Function<Point, Point> jfxPanelAdjustment;
        private Function<Point, Point> pointScale;

        private Builder(BrowserWidget widget) {
            this.widget = widget;
        }

        Builder inputMethods(InputMethods inputMethods) {
            this.inputMethods = inputMethods;
            return this;
        }

        Builder dnd(DragAndDropBridge dnd) {
            this.dnd = dnd;
            return this;
        }

        Builder jfxPanelAdjustment(Function<Point, Point> jfxPanelAdjustment) {
            this.jfxPanelAdjustment = jfxPanelAdjustment;
            return this;
        }

        Builder pointScale(Function<Point, Point> pointScale) {
            this.pointScale = pointScale;
            return this;
        }

        MouseListener build() {
            return new MouseListener(this.widget, this.inputMethods, this.dnd, this.jfxPanelAdjustment, this.pointScale);
        }
    }
}

