/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.internal.DropDownCreated;
import com.teamdev.jxbrowser.browser.event.internal.DropDownDeleted;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.NativeKeyboardListener;
import com.teamdev.jxbrowser.browser.internal.callback.AccessibilityRequestFocusCallback;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityRequestFocus;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.AncestorsVisibilityTracker;
import com.teamdev.jxbrowser.view.javafx.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import com.teamdev.jxbrowser.view.javafx.internal.NodeVisibility;
import com.teamdev.jxbrowser.view.javafx.internal.ParentTabTracker;
import com.teamdev.jxbrowser.view.javafx.internal.RenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.dnd.DragAndDropBridge;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.ContentNode;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.CursorListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.FocusListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethods;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.KeyListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.MouseListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.SceneTracker;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.ScrollListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.SizeChangedListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.TakeFocusCallback;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.TooltipListener;
import com.teamdev.jxbrowser.view.javafx.internal.window.FxPanel;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;

public abstract class OffScreenRenderWidget<N extends Node>
implements RenderWidget<N> {
    protected final BrowserWidget widget;
    private final BrowserView browserView;
    private final ContentNode<N> node;
    private final InputMethods inputMethods;
    private final DragAndDropBridge dnd;
    private final SceneTracker sceneTracker;
    private final DisplayWatcher displayWatcher;
    private final ParentTabTracker tabTracker;
    private final AncestorsVisibilityTracker ancestorsVisibilityTracker;
    private final FocusListener focusListener;
    private final KeyListener keyListener;
    private final NativeKeyboardListener nativeKeyboardListener;
    private final MouseListener mouseListener;
    private final ScrollListener scrollListener;
    private final SizeChangedListener sizeChangedListener;
    private final CursorListener cursorListener;
    private final TooltipListener tooltipListener;
    private final TakeFocusCallback takeFocusCallback;
    private final Subscription browserClosed;
    private Subscription dropDownCreated;
    private Subscription dropDownDeleted;
    private boolean isDndEnabled;
    private boolean isWidgetShown;

    OffScreenRenderWidget(BrowserWidget widget, BrowserView browserView, ContentNode<N> node) {
        this.widget = widget;
        this.browserView = browserView;
        this.node = node;
        this.inputMethods = new InputMethods(widget, this::window, this::scaleFactor);
        this.isDndEnabled = true;
        this.dnd = DragAndDropBridge.newBuilder(widget).pointScale(this::scalePoint).build();
        this.tabTracker = ParentTabTracker.newBuilder().forNode((Node)browserView).whenTabSelected(this::show).whenTabDeselected(this::onTabDeselected).build();
        this.sceneTracker = SceneTracker.newBuilder().forNode((Node)browserView).onSceneSwitched(this.tabTracker::reattach).onWindowAppeared(this::show).onWindowDisappeared(this::hide).onWindowMoved(this::updateBounds).onWindowMinimized(() -> ((BrowserWidget)widget).minimize()).onWindowMaximized(() -> ((BrowserWidget)widget).restore()).build();
        this.displayWatcher = DisplayWatcher.newBuilder().onDisplayChanged(this::updateDisplay).build();
        this.ancestorsVisibilityTracker = AncestorsVisibilityTracker.newBuilder().browserView(browserView).onShow(this::show).onHide(this::hide).build();
        this.nativeKeyboardListener = NativeKeyboardListener.create((BrowserWidget)widget, this::interceptNativeKeyEvent);
        this.mouseListener = MouseListener.newBuilder(widget).dnd(this.dnd).inputMethods(this.inputMethods).pointScale(this::scalePoint).jfxPanelAdjustment(this::adjustPointConsideringFxPanel).build();
        this.scrollListener = ScrollListener.newBuilder(widget).pointScale(this::scalePoint).jfxPanelAdjustment(this::adjustPointConsideringFxPanel).build();
        this.keyListener = new KeyListener(this.inputMethods, widget);
        this.focusListener = new FocusListener(widget, this.inputMethods);
        this.cursorListener = new CursorListener(widget);
        this.tooltipListener = new TooltipListener(widget);
        this.takeFocusCallback = new TakeFocusCallback(widget);
        this.sizeChangedListener = new SizeChangedListener(this::updateBounds);
        this.browserClosed = widget.browser().on(BrowserClosed.class, e -> this.close());
        this.ancestorsVisibilityTracker.attach();
        this.sceneTracker.attach();
    }

    DisplayWatcher displayWatcher() {
        return this.displayWatcher;
    }

    protected void show() {
        if (this.isWidgetShown || this.window() == null || !NodeVisibility.isVisibleOnScene((Node)this.browserView)) {
            return;
        }
        Object toolkitNode = this.node.toolkitNode();
        this.configureNewNode((Node)toolkitNode);
        this.browserView.getChildren().add(toolkitNode);
        if (this.isDndEnabled) {
            this.dnd.attach((Node)toolkitNode);
        }
        this.sceneTracker.startTrackingLocation();
        this.sceneTracker.startTrackingMinimizing();
        NativeAwareWindow window = this.window();
        this.displayWatcher.attach(window);
        this.inputMethods.attach((Node)toolkitNode);
        this.sizeChangedListener.attach(this.node);
        this.focusListener.attach((Node)toolkitNode);
        this.mouseListener.attach((Node)toolkitNode);
        this.scrollListener.attach((Node)toolkitNode);
        this.cursorListener.attach((Node)toolkitNode);
        this.tooltipListener.attach((Node)toolkitNode);
        this.takeFocusCallback.attach((Node)toolkitNode);
        this.attachKeyboardListener((Node)toolkitNode);
        window.findNativeId().ifPresent(arg_0 -> ((BrowserWidget)this.widget).assignHostWindow(arg_0));
        this.widget.show();
        if (toolkitNode.isFocused()) {
            this.widget.focus();
        }
        this.updateBounds();
        if (Environment.isMac()) {
            this.dropDownCreated = this.widget.on(DropDownCreated.class, event -> this.focusListener.skipUnfocus(true));
            this.dropDownDeleted = this.widget.on(DropDownDeleted.class, event -> this.focusListener.skipUnfocus(false));
        }
        if (Environment.isMac()) {
            this.widget.set(AccessibilityRequestFocusCallback.class, (BrowserWidgetCallback)((AccessibilityRequestFocusCallback)params -> {
                if (!toolkitNode.isFocused()) {
                    Platform.runLater(() -> ((Node)toolkitNode).requestFocus());
                }
                return AccessibilityRequestFocus.Response.newBuilder().setFocusAcquired(true).build();
            }));
        }
        this.isWidgetShown = true;
    }

    private void attachKeyboardListener(Node toolkitNode) {
        if (Boolean.getBoolean("jxbrowser.use.native.keyboard.input")) {
            Optional<Long> windowHandle = this.window().findNativeId();
            if (windowHandle.isPresent()) {
                this.nativeKeyboardListener.start(windowHandle.get().longValue(), toolkitNode.isFocused());
            } else {
                this.keyListener.attach(toolkitNode);
                Logger.warn((String)"Failed to find the native window handle. Falling back to Java keyboard input.");
            }
        } else {
            this.keyListener.attach(toolkitNode);
        }
    }

    private Point adjustPointConsideringFxPanel(Point fxPanelPosition) {
        NativeAwareWindow window = this.window();
        if (window != null) {
            return FxPanel.localPoint(window, fxPanelPosition);
        }
        return fxPanelPosition;
    }

    private void detachKeyboardListener() {
        if (this.nativeKeyboardListener.isActive()) {
            this.nativeKeyboardListener.stop();
        } else {
            this.keyListener.detach();
        }
    }

    protected void hide() {
        if (!this.isWidgetShown) {
            return;
        }
        this.browserView.getChildren().remove(this.node.toolkitNode());
        this.displayWatcher.detach();
        this.dnd.detach();
        this.inputMethods.detach();
        this.takeFocusCallback.detach();
        this.focusListener.detach();
        this.mouseListener.detach();
        this.scrollListener.detach();
        this.detachKeyboardListener();
        if (!this.widget.isClosed()) {
            this.widget.hide();
        }
        this.sceneTracker.stopTrackingMinimizing();
        this.sceneTracker.stopTrackingLocation();
        if (!this.trackSizeWhenHidden()) {
            this.sizeChangedListener.detach();
        }
        this.cursorListener.detach();
        this.tooltipListener.detach();
        if (Environment.isMac()) {
            this.dropDownCreated.unsubscribe();
            this.dropDownDeleted.unsubscribe();
        }
        this.isWidgetShown = false;
    }

    protected boolean isWidgetShown() {
        return this.isWidgetShown;
    }

    private void onTabDeselected() {
        if (this.node.toolkitNode().isFocused()) {
            this.widget.unfocus();
        }
        this.hide();
    }

    public void enableDragAndDrop() {
        this.isDndEnabled = true;
        if (this.node != null) {
            this.dnd.attach((Node)this.node.toolkitNode());
        }
    }

    public void disableDragAndDrop() {
        this.isDndEnabled = false;
        this.dnd.detach();
    }

    protected abstract boolean trackSizeWhenHidden();

    protected void close() {
        this.browserClosed.unsubscribe();
        Platform.runLater(() -> {
            this.tabTracker.detach();
            this.sceneTracker.detach();
            this.ancestorsVisibilityTracker.detach();
            this.sizeChangedListener.detach();
            this.hide();
        });
    }

    private void configureNewNode(Node node) {
        node.setFocusTraversable(true);
        this.requestFocusOnMousePressed(node);
        this.setUpMouseEventConsumer(node);
    }

    private void requestFocusOnMousePressed(Node node) {
        node.setOnMousePressed(event -> Platform.runLater(() -> ((Node)node).requestFocus()));
    }

    private void setUpMouseEventConsumer(Node node) {
        node.addEventHandler(MouseEvent.ANY, Event::consume);
    }

    private void updateDisplay(Display display) {
        this.widget.displayId(display.id());
        this.updateBounds();
    }

    protected NativeAwareWindow window() {
        return this.sceneTracker.window();
    }

    private double scaleFactor() {
        return this.displayWatcher.display().scaleFactor();
    }

    protected void updateBounds() {
        if (this.node == null) {
            return;
        }
        int width = (int)this.node.getWidth();
        int height = (int)this.node.getHeight();
        N toolkitNode = this.node.toolkitNode();
        Scene scene = toolkitNode.getScene();
        if (width > 0 && height > 0 && scene != null) {
            Point2D widgetLocation = toolkitNode.localToScreen(0.0, 0.0);
            double screenX = widgetLocation.getX();
            double screenY = widgetLocation.getY();
            double sceneX = scene.getX();
            double sceneY = scene.getY();
            Window window = scene.getWindow();
            double windowX = window.getX();
            double windowY = window.getY();
            Point inWindow = Point.of((int)((int)Math.round(screenX - windowX - sceneX)), (int)((int)Math.round(screenY - windowY - sceneY)));
            inWindow = FxPanel.inWindowPoint(window, this.node.getHeight(), inWindow);
            Rect boundsInWindow = Geometry.newRect((double)inWindow.x(), (double)inWindow.y(), (double)width, (double)height);
            Rect boundsInScreen = Geometry.newRect((double)screenX, (double)screenY, (double)width, (double)height);
            if (!HiDpi.isPlatformDpiAware(this.scaleFactor())) {
                boundsInWindow = Geometry.scaleDown((Rect)boundsInWindow, (double)this.scaleFactor());
                boundsInScreen = Geometry.scaleDown((Rect)boundsInScreen, (double)this.scaleFactor());
            }
            this.widget.bounds(boundsInWindow, boundsInScreen);
        }
    }

    private Point scalePoint(Point point) {
        if (!HiDpi.isPlatformDpiAware(this.scaleFactor())) {
            point = Geometry.scaleDown((Point)point, (double)this.scaleFactor());
        }
        return point;
    }

    private void interceptNativeKeyEvent(NativeKeyEvent keyEvent) {
        Platform.runLater(() -> this.widget.dispatch(keyEvent));
    }

    @Override
    public Optional<N> node() {
        if (this.node != null) {
            return Optional.of(this.node.toolkitNode());
        }
        return Optional.empty();
    }
}

