/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.base.Splitter;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.MacOsCompatibility;
import com.teamdev.jxbrowser.view.swing.internal.dnd.StringDataFlavor;
import java.awt.datatransfer.Transferable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;

final class UrlDataType
extends DataType {
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final StringDataFlavor URI_LIST = StringDataFlavor.newInstance("text/uri-list");
    private static final StringDataFlavor JAVA_URL = StringDataFlavor.newInstance("application/x-java-url");
    private static final StringDataFlavor MOZ_URL = StringDataFlavor.newInstance("text/x-moz-url", StandardCharsets.UTF_16LE);

    UrlDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        Optional<String> url;
        if (Environment.isMac() && (url = MacOsCompatibility.readUrlFromPasteboard()).isPresent()) {
            dropData.setUrl(url.get());
            return;
        }
        Optional<StringDataFlavor> flavor = this.supportedFlavors().stream().filter(it -> it.isPresentedIn(transferable)).findFirst();
        flavor.ifPresent(it -> {
            String url = this.extractUrl(it.read(transferable));
            dropData.setUrl(url);
        });
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
        metadata.setContainsUrl(true);
    }

    private String extractUrl(String rawString) {
        String separator = rawString.contains(CRLF) ? CRLF : LF;
        return (String)Splitter.on((String)separator).splitToList((CharSequence)rawString).get(0);
    }

    protected List<StringDataFlavor> supportedFlavors() {
        return ImmutableList.of((Object)URI_LIST, (Object)JAVA_URL, (Object)MOZ_URL);
    }
}

