/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.OpenFile;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;

public interface OpenFileCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<OpenFile.Response> {
        public Action(Consumer<OpenFile.Response> consumer) {
            super(consumer);
        }

        public void open(Path filePath) {
            Preconditions.checkNotNull(filePath);
            this.send(OpenFile.Response.newBuilder().setOpenFile(FilePath.newBuilder().setValue(filePath.toAbsolutePath().toString()).build()).build());
        }

        public void cancel() {
            this.send(OpenFile.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public String suggestedDirectory() {
            return OpenFile.Request.cast(this).getSuggestedDirectory().getValue();
        }

        default public List<String> acceptableExtensions() {
            return OpenFile.Request.cast(this).getAcceptableExtensionList();
        }

        default public String filterDescription() {
            return OpenFile.Request.cast(this).getFilterDescription();
        }

        default public boolean acceptAll() {
            return OpenFile.Request.cast(this).getAcceptAll();
        }
    }
}

