/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.callback.DragAndDropCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragAndDropStub;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class DragAndDrop
extends CloseableImpl
implements Advisable<DragAndDropCallback> {
    private final BrowserImpl browser;
    private final ServiceConnectionImpl<DragAndDropStub> rpc;

    DragAndDrop(BrowserImpl browser) {
        this.browser = browser;
        this.rpc = new ServiceConnectionImpl<DragAndDropStub>(browser.id(), browser.engine().connection(), DragAndDropStub::new);
    }

    public void enable() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::enable, this.browser.id());
    }

    public void disable() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::disable, this.browser.id());
    }

    public CompletableFuture<Boolean> isEnabled() {
        return this.getBoolean(this.rpc.stub()::isEnabled);
    }

    public void ifEnabled(Runnable task) {
        this.isEnabled().whenComplete((isEnabled, throwable) -> {
            if (isEnabled.booleanValue()) {
                task.run();
            }
        });
    }

    public boolean isEnabledSync() {
        return this.getBooleanSync(this.rpc.stub()::isEnabled);
    }

    public void enableExternalDrag() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::enableExternalDrag, this.browser.id());
    }

    public void disableExternalDrag() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::disableExternalDrag, this.browser.id());
    }

    public boolean isExternalDragEnabledSync() {
        return this.getBooleanSync(this.rpc.stub()::isExternalDragEnabled);
    }

    private boolean getBooleanSync(ServiceMethod<BrowserId, BoolValue> booleanCall) {
        try {
            return this.getBoolean(booleanCall).get();
        }
        catch (Exception e) {
            Logger.error("Couldn't get the value.", e);
            return false;
        }
    }

    private CompletableFuture<Boolean> getBoolean(ServiceMethod<BrowserId, BoolValue> booleanCall) {
        this.checkNotClosed();
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.rpc.invokeAsync(booleanCall, this.browser.id(), new RpcCallback<BoolValue>(){

            @Override
            public void onNext(BoolValue value) {
                future.complete(value.getValue());
            }

            @Override
            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    @Override
    public <C extends DragAndDropCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((DragAndDropCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends DragAndDropCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends DragAndDropCallback> C remove(Class<C> callbackClass) {
        return (C)((DragAndDropCallback)this.rpc.remove(callbackClass));
    }
}

