/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.UnsupportedRenderingModeException;
import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.NativeEventListenerLinux;
import com.teamdev.jxbrowser.browser.internal.NativeEventListenerMac;
import com.teamdev.jxbrowser.browser.internal.NativeEventListenerWin;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeMouseEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeWindowsTouchEvent;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeEventListener {
    static double DEFAULT_FORCED_SCALE_FACTOR = 0.0;
    private final BrowserWidget widget;
    final EventInterceptor interceptor;
    final AtomicBoolean isChromiumFocused;
    final AtomicBoolean mouseInView;
    private final AtomicBoolean isActive;
    private final String uuid;
    private final boolean isPlatformDpiAware;
    private final double forcedScaleFactor;
    private long windowId;
    private Subscription focusGained;
    private Subscription focusLost;
    private Rect viewBounds;

    public static NativeEventListener createDpiAware(BrowserWidget widget, EventInterceptor interceptor) {
        return NativeEventListener.create(widget, interceptor, true, DEFAULT_FORCED_SCALE_FACTOR);
    }

    public static NativeEventListener createDpiAware(BrowserWidget widget, EventInterceptor interceptor, double forcedScaleFactor) {
        Preconditions.checkArgument(Double.compare(forcedScaleFactor, DEFAULT_FORCED_SCALE_FACTOR) > 0);
        return NativeEventListener.create(widget, interceptor, true, forcedScaleFactor);
    }

    public static NativeEventListener createDpiUnaware(BrowserWidget widget, EventInterceptor interceptor) {
        return NativeEventListener.create(widget, interceptor, false, DEFAULT_FORCED_SCALE_FACTOR);
    }

    private static NativeEventListener create(BrowserWidget widget, EventInterceptor interceptor, boolean isPlatformDpiAware, double forcedScaleFactor) {
        Preconditions.checkNotNull(widget);
        Preconditions.checkArgument(Double.compare(forcedScaleFactor, DEFAULT_FORCED_SCALE_FACTOR) >= 0);
        if (Environment.isMac()) {
            return new NativeEventListenerMac(widget, interceptor, isPlatformDpiAware, forcedScaleFactor);
        }
        if (Environment.isWindows()) {
            NativeEventListener.checkOffScreen(widget);
            return new NativeEventListenerWin(widget, interceptor, isPlatformDpiAware, forcedScaleFactor);
        }
        NativeEventListener.checkOffScreen(widget);
        return new NativeEventListenerLinux(widget, interceptor, isPlatformDpiAware, forcedScaleFactor);
    }

    NativeEventListener(BrowserWidget widget, EventInterceptor interceptor, boolean isPlatformDpiAware, double forcedScaleFactor) {
        this.interceptor = interceptor;
        this.widget = widget;
        this.isChromiumFocused = new AtomicBoolean();
        this.mouseInView = new AtomicBoolean();
        this.isActive = new AtomicBoolean();
        this.uuid = UUID.randomUUID().toString();
        this.viewBounds = Rect.empty();
        this.isPlatformDpiAware = isPlatformDpiAware;
        this.forcedScaleFactor = forcedScaleFactor;
    }

    private static void checkOffScreen(BrowserWidget widget) {
        RenderingMode renderingMode = widget.browser().engine().options().renderingMode();
        if (renderingMode != RenderingMode.OFF_SCREEN) {
            throw new UnsupportedRenderingModeException(renderingMode);
        }
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public void start(long windowId, boolean focused) {
        Preconditions.checkArgument(windowId > 0L);
        this.isActive.set(true);
        this.windowId = windowId;
        this.isChromiumFocused.set(focused);
        this.focusGained = this.widget.browser().on(FocusGained.class, event -> this.isChromiumFocused.set(true));
        this.focusLost = this.widget.browser().on(FocusLost.class, event -> this.isChromiumFocused.set(false));
        this.interceptor.start();
        ToolkitLibrary.instance().addEventListener(this, this.uuid, windowId);
    }

    public void stop() {
        this.isActive.set(false);
        this.focusGained.unsubscribe();
        this.focusLost.unsubscribe();
        this.interceptor.stop();
        ToolkitLibrary.instance().removeEventListener(this.uuid, this.windowId);
    }

    public void updateBounds(Rect bounds) {
        this.viewBounds = bounds;
    }

    public void mouseEntered() {
        this.mouseInView.set(true);
    }

    public void mouseExited() {
        this.mouseInView.set(false);
    }

    Rect viewBounds() {
        return this.viewBounds;
    }

    boolean isPlatformDpiAware() {
        return this.isPlatformDpiAware;
    }

    double getForcedScaleFactor() {
        return this.forcedScaleFactor;
    }

    public static interface EventInterceptor {
        public void intercept(NativeKeyEvent var1);

        public void intercept(NativeMouseEvent var1, MouseEventType var2);

        public void intercept(NativeWindowsTouchEvent var1);

        default public void start() {
        }

        default public void stop() {
        }

        public static enum TouchEventType {
            PRESSED,
            MOVED,
            RELEASED;

        }

        public static enum MouseEventType {
            MOVE,
            PRESS,
            RELEASE,
            DRAG,
            WHEEL,
            LEAVE;

        }
    }
}

