/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.NativeEventListener;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.TouchType;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeMouseEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeWindowsKeyEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeWindowsMouseEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeWindowsTouchEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint;
import com.teamdev.jxbrowser.ui.internal.rpc.Point;
import java.util.concurrent.atomic.AtomicBoolean;

final class NativeEventListenerWin
extends NativeEventListener {
    private final AtomicBoolean mouseEnteredWindow = new AtomicBoolean(false);

    NativeEventListenerWin(BrowserWidget widget, NativeEventListener.EventInterceptor interceptor, boolean isPlatformDpiAware, double forcedScaleFactor) {
        super(widget, interceptor, isPlatformDpiAware, forcedScaleFactor);
    }

    public void onKeyEvent(int eventType, int wparam, long lparam, int keyChar) {
        if (this.isChromiumFocused.get()) {
            NativeWindowsKeyEvent windowsKeyEvent = NativeWindowsKeyEvent.newBuilder().setType(eventType).setWParam(wparam).setKeyChar(keyChar).setLParam(lparam).build();
            NativeKeyEvent keyEvent = NativeKeyEvent.newBuilder().setWinKey(windowsKeyEvent).build();
            this.interceptor.intercept(keyEvent);
        }
    }

    public void onTouchEvent(int pointerId, int eventType, int x, int y, float radiusX, float radiusY, float pressure, int rotationAngle) {
        NativeWindowsTouchEvent touchEvent = NativeWindowsTouchEvent.newBuilder().setType(switch (NativeEventListener.EventInterceptor.TouchEventType.values()[eventType]) {
            case NativeEventListener.EventInterceptor.TouchEventType.PRESSED -> TouchType.PRESSED;
            case NativeEventListener.EventInterceptor.TouchEventType.RELEASED -> TouchType.RELEASED;
            default -> TouchType.MOVED;
        }).setPointerId(pointerId).setTouchPoint(TouchPoint.newBuilder().setRadiusX(radiusX).setRadiusY(radiusY).setPositionInWidget(Point.newBuilder().setX(x).setY(y).build()).setForce(pressure).setRotationAngle(rotationAngle).build()).build();
        this.interceptor.intercept(touchEvent);
    }

    public void onMouseEvent(int messageType, int wparam, int x, int y, int eventType, double systemScaleFactor) {
        NativeEventListener.EventInterceptor.MouseEventType mouseEventType = NativeEventListener.EventInterceptor.MouseEventType.values()[eventType];
        if (mouseEventType == NativeEventListener.EventInterceptor.MouseEventType.LEAVE) {
            this.dispatchMouseLeaveEvent();
        } else {
            boolean dragging;
            Rect bounds = this.viewBounds();
            boolean bl = dragging = mouseEventType == NativeEventListener.EventInterceptor.MouseEventType.DRAG;
            if (this.mouseInView.get() || dragging) {
                double scaleFactor = this.determineEffectiveScaleFactor(systemScaleFactor);
                int widgetX = (int)((double)x / (this.isPlatformDpiAware() ? scaleFactor : 1.0) - (double)bounds.x());
                int widgetY = (int)((double)y / (this.isPlatformDpiAware() ? scaleFactor : 1.0) - (double)bounds.y());
                this.dispatchMouseEvent(messageType, wparam, widgetX, widgetY, mouseEventType);
                this.mouseEnteredWindow.set(true);
            } else {
                this.dispatchMouseLeaveEvent();
            }
        }
    }

    private double determineEffectiveScaleFactor(double systemScaleFactor) {
        double forcedScaleFactor = this.getForcedScaleFactor();
        if (Double.compare(forcedScaleFactor, DEFAULT_FORCED_SCALE_FACTOR) > 0) {
            return forcedScaleFactor;
        }
        return systemScaleFactor;
    }

    private void dispatchMouseLeaveEvent() {
        int mouseLeaveEvent = 675;
        if (this.mouseEnteredWindow.get()) {
            this.mouseEnteredWindow.set(false);
            this.dispatchMouseEvent(675, 0, 0, 0, NativeEventListener.EventInterceptor.MouseEventType.LEAVE);
        }
    }

    private void dispatchMouseEvent(int messageType, int wparam, int x, int y, NativeEventListener.EventInterceptor.MouseEventType eventType) {
        NativeWindowsMouseEvent windowsMouseEvent = NativeWindowsMouseEvent.newBuilder().setType(messageType).setWParam(wparam).build();
        NativeMouseEvent mouseEvent = NativeMouseEvent.newBuilder().setLocation(Point.newBuilder().setX(x).setY(y).build()).setWinMouse(windowsMouseEvent).build();
        this.interceptor.intercept(mouseEvent, eventType);
    }
}

