/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.engine.MissingDependencyException;
import com.teamdev.jxbrowser.engine.internal.PosixCommandLookup;
import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.ChromiumExecutable;
import com.teamdev.jxbrowser.internal.JniLibraryName;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LinuxDependencies {
    private final Path chromiumDir;
    private final ChromiumExecutable chromiumExecutable;

    LinuxDependencies(Path chromiumDir) {
        this.chromiumDir = chromiumDir;
        this.chromiumExecutable = ChromiumExecutable.from(chromiumDir);
    }

    void checkAvailability() {
        if (SystemProperties.hasProperty("jxbrowser.linux.deps.check.disabled")) {
            Logger.debug("Dependency check was explicitly switched off.");
            return;
        }
        Optional<Path> ldd = PosixCommandLookup.findCommandExecutable("ldd");
        ldd.ifPresent(lddPath -> {
            Logger.debug("Analyzing dependencies...");
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            try {
                for (Path file : this.verifiableFiles()) {
                    this.findMissingDependencies((Path)lddPath, file).ifPresent(dependencies -> result.put(file.toFile().getName(), (Set<String>)dependencies));
                }
            }
            catch (IOException e) {
                Logger.warn("Analyzing dependencies... [FAIL]", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.error("Analyzing dependencies... [FAIL]", e);
            }
            if (!result.isEmpty()) {
                throw new MissingDependencyException(result);
            }
        });
        if (!ldd.isPresent()) {
            Logger.debug("Couldn't find `ldd`. Dependency validation was skipped.");
        }
    }

    private Optional<Set<String>> findMissingDependencies(Path lddPath, Path libraryPath) throws InterruptedException {
        Path libraryFileName = libraryPath.getFileName();
        Logger.debug("{0}...", libraryFileName);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        this.configureEnvironment(processBuilder);
        processBuilder.command(lddPath.toString(), libraryPath.toAbsolutePath().toString());
        try {
            Process process = processBuilder.start();
            List<String> streamOutput = this.readLinesFromInputStream(process.getInputStream());
            String errorMessage = this.createErrorMessage(process.getErrorStream());
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return this.extractMissingDependencies(streamOutput);
            }
            Logger.info(errorMessage);
            return Optional.empty();
        }
        catch (IOException e) {
            Logger.warn(e, () -> libraryFileName + "... [FAIL]");
            return Optional.empty();
        }
    }

    private void configureEnvironment(ProcessBuilder processBuilder) {
        processBuilder.environment().put("LC_ALL", "C");
    }

    private List<Path> verifiableFiles() throws IOException {
        BinariesListing listing = Environment.isArm() ? BinariesListing.LINUX_ARM : BinariesListing.LINUX;
        Stream<Object> files = listing.exists() ? listing.files().stream().map(file -> file.absolutePath(this.chromiumDir)) : this.fileTree().stream();
        return files.filter(this::isChromiumBinary).filter(this::canBeVerified).collect(Collectors.toList());
    }

    private List<Path> fileTree() throws IOException {
        try (Stream<Path> fileTree = Files.walk(this.chromiumDir, new FileVisitOption[0]);){
            List<Path> list = fileTree.collect(Collectors.toList());
            return list;
        }
    }

    private boolean canBeVerified(Path path) {
        return !path.endsWith(JniLibraryName.AWT_TOOLKIT.toPlatform());
    }

    private boolean isChromiumBinary(Path path) {
        boolean isSharedLibrary = path.toString().endsWith(".so");
        boolean isChromiumExecutable = path.getFileName().toString().equals(this.chromiumExecutable.name());
        return Files.isRegularFile(path, new LinkOption[0]) && (isSharedLibrary || isChromiumExecutable);
    }

    private List<String> readLinesFromInputStream(InputStream inputStream) throws IOException {
        try (BufferedReader reader = this.bufferedReader(inputStream);){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    private BufferedReader bufferedReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
    }

    private Optional<Set<String>> extractMissingDependencies(List<String> lines) {
        HashSet result = new HashSet();
        lines.forEach(line -> {
            String libName;
            int pos = line.indexOf("not found");
            if (pos != -1 && !(libName = line.split("=>", -1)[0]).contains("jawt")) {
                result.add(libName.trim());
            }
        });
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private String createErrorMessage(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, Charset.defaultCharset().name()).useDelimiter("\\A");
        String result = scanner.hasNext() ? scanner.next().trim() : "";
        inputStream.close();
        return result;
    }
}

