/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class PosixCommandLookup {
    private static final String ROOT_USER = "root";

    private PosixCommandLookup() {
    }

    public static Optional<Path> findCommandExecutable(String command) {
        Logger.debug("Finding the executable for {0}...", command);
        Optional<Path> result = PosixCommandLookup.findExecutablePathByLocations(command);
        if (result.isPresent()) {
            return result;
        }
        return PosixCommandLookup.findExecutableByWhichUtil(command);
    }

    private static Optional<Path> findExecutablePathByLocations(String executable) {
        Logger.debug("Finding the {0} executable in PATH...", executable);
        for (String dir : System.getenv("PATH").split(File.pathSeparator, -1)) {
            Path commandFile = Paths.get(dir, executable);
            if (!PosixCommandLookup.isValidCommand(commandFile)) continue;
            Logger.debug("Finding the {0} executable in PATH... [OK]", executable);
            return Optional.of(commandFile);
        }
        Logger.debug("Finding the {0} executable in PATH... [FAIL]", executable);
        return Optional.empty();
    }

    private static Optional<Path> findExecutableByWhichUtil(String executable) {
        AtomicReference result = new AtomicReference();
        PosixCommandLookup.findExecutablePathByLocations("which").ifPresent(path -> {
            Logger.debug("Finding the {0} executable using 'which'...", executable);
            ProcessBuilder processBuilder = new ProcessBuilder(path.toString(), executable);
            try {
                Process process = processBuilder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    Logger.debug("Finding the {0} executable using 'which'... [OK]", executable);
                    Path commandFile = Paths.get(PosixCommandLookup.parseOutput(process.getInputStream()), new String[0]);
                    if (PosixCommandLookup.isValidCommand(commandFile)) {
                        result.set(Paths.get(PosixCommandLookup.parseOutput(process.getInputStream()), new String[0]));
                    }
                } else {
                    Logger.debug("Finding the {0} executable using 'which'... [FAIL]", executable);
                }
            }
            catch (IOException e) {
                Logger.warn(e, () -> "Finding the " + executable + " executable using 'which'... [FAIL]");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.warn(e, () -> "Finding the " + executable + " executable using 'which'... [FAIL]");
            }
        });
        return Optional.ofNullable((Path)result.get());
    }

    private static String parseOutput(InputStream inputStream) throws IOException {
        try (BufferedReader reader = PosixCommandLookup.bufferedReader(inputStream);){
            String string = reader.readLine();
            return string;
        }
    }

    private static BufferedReader bufferedReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
    }

    private static boolean isValidCommand(Path file) {
        return Files.exists(file, new LinkOption[0]) && Files.isExecutable(file) && PosixCommandLookup.isOwnedByRoot(file);
    }

    private static boolean isOwnedByRoot(Path file) {
        try {
            String ownerName = Files.getOwner(file, new LinkOption[0]).getName();
            return ROOT_USER.equals(ownerName);
        }
        catch (IOException | SecurityException e) {
            Logger.debug(String.format("Failed to check ownership of %s", file), e);
            return false;
        }
    }
}

